/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import com.google.common.collect.Multimap;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloBaseListActivity;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.BaseTextWatcher;
import fr.ifremer.wlo.utils.UIUtils;
import fr.ifremer.wlo.utils.WloAutoCompleteTextViewWithFavorites;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public abstract class WloModelEditionActivity<M extends BaseModel>
extends WloBaseActivity {
    private static final String TAG = "WloModelEditionActivity";
    public static final String INTENT_EXTRA_PARENT_MODEL = "parentModel";
    public static final String INTENT_EXTRA_MODEL = "model";
    protected M model;

    protected abstract Class<? extends WloModelEditionActivity> getNextEditionActivity();

    protected abstract Class<? extends WloBaseListActivity> getNextListActivity();

    protected abstract M createNewModel();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"on create");
        super.onCreate(savedInstanceState);
        this.model = (BaseModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_MODEL);
        if (this.model == null) {
            this.model = this.createNewModel();
            if (HierarchicalModel.class.isAssignableFrom(this.model.getClass())) {
                BaseModel parent = (BaseModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_PARENT_MODEL);
                HierarchicalModel hModel = (HierarchicalModel)this.model;
                hModel.setParent(parent);
            }
        } else {
            this.setTitle(((BaseModel)this.model).toString((Context)this));
        }
        ((BaseModel)this.model).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Log.d((String)WloModelEditionActivity.TAG, (String)"modified !");
                ((BaseModel)WloModelEditionActivity.this.model).setModified(true);
            }
        });
        this.getWindow().setSoftInputMode(3);
    }

    @Override
    public Intent getSupportParentActivityIntent() {
        Intent intent = super.getSupportParentActivityIntent();
        if (intent != null && HierarchicalModel.class.isAssignableFrom(this.model.getClass())) {
            HierarchicalModel hModel = (HierarchicalModel)this.model;
            intent.putExtra(INTENT_EXTRA_PARENT_MODEL, hModel.getParent());
        }
        return intent;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131623936, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131099799: {
                if (((BaseModel)this.model).isModified()) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                    DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (which == -1) {
                                WloModelEditionActivity.this.saveModel();
                            }
                            WloModelEditionActivity.this.openNewModelEdition();
                        }
                    };
                    builder.setMessage(2131427473).setNegativeButton(0x1040000, UIUtils.getCancelClickListener()).setNeutralButton(2131427343, listener).setPositiveButton(2131427342, listener).create().show();
                } else {
                    this.openNewModelEdition();
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void validate(View view) {
        boolean newModel = ((BaseModel)this.model).isNew();
        Multimap<BaseModel.ErrorType, String> errors = ((BaseModel)this.model).checkValidity();
        if (errors.isEmpty()) {
            this.saveModel();
            if (newModel) {
                Intent intent = new Intent((Context)this, this.getNextListActivity());
                intent.putExtra(INTENT_EXTRA_PARENT_MODEL, this.model);
                this.startActivity(intent);
            } else {
                Intent intent = new Intent();
                intent.putExtra(INTENT_EXTRA_MODEL, this.model);
                this.setResult(-1, intent);
                this.finish();
            }
        } else {
            View root = this.findViewById(0x1020002);
            Collection requiredFields = errors.get((Object)BaseModel.ErrorType.REQUIRED);
            String errorMessage = this.getString(2131427344);
            for (String field : requiredFields) {
                View v = root.findViewWithTag((Object)field);
                if (v == null || !EditText.class.isAssignableFrom(v.getClass())) continue;
                ((EditText)v).setError((CharSequence)errorMessage);
            }
            Collection oneRequiredFields = errors.get((Object)BaseModel.ErrorType.ONE_REQUIRED);
            errorMessage = this.getString(2131427345);
            for (String field : oneRequiredFields) {
                View v = root.findViewWithTag((Object)field);
                if (v == null || !EditText.class.isAssignableFrom(v.getClass())) continue;
                ((EditText)v).setError((CharSequence)errorMessage);
            }
        }
    }

    protected void saveModel() {
        WloSqlOpenHelper woh = new WloSqlOpenHelper((Context)this);
        woh.saveData(this.model);
        woh.close();
    }

    protected void initEditText(int editorId, String attribute) {
        this.initEditText(editorId, attribute, null);
    }

    protected void initEditText(int editorId, String attribute, String defaultValue) {
        EditText editText = (EditText)this.findViewById(editorId);
        this.initEditText(editText, attribute, defaultValue);
    }

    protected void initEditText(final EditText editText, String attribute, String defaultValue) {
        final Class<?> clazz = this.model.getClass();
        final String firtsLetterUpperCaseAttribute = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
        editText.setTag((Object)attribute);
        try {
            Object value = clazz.getMethod("get" + firtsLetterUpperCaseAttribute, new Class[0]).invoke(this.model, new Object[0]);
            editText.setText((CharSequence)(value != null ? value.toString() : defaultValue));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)("Error on get" + firtsLetterUpperCaseAttribute + " for class " + clazz), (Throwable)e);
        }
        editText.addTextChangedListener((TextWatcher)new BaseTextWatcher(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                try {
                    clazz.getMethod("set" + firtsLetterUpperCaseAttribute, String.class).invoke(WloModelEditionActivity.this.model, s.toString());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Log.e((String)WloModelEditionActivity.TAG, (String)("Error on set" + firtsLetterUpperCaseAttribute + " for class " + clazz), (Throwable)e);
                }
                editText.setError(null);
                editText.setSelection(start + count);
            }
        });
        this.addModelPropertyChangeListener(editText, attribute, true);
    }

    protected <R> AutoCompleteTextView initAutoCompleteTextView(int autoCompleteTextViewId, String attribute, Collection<R> data) {
        return this.initAutoCompleteTextView(autoCompleteTextViewId, attribute, data, null);
    }

    protected <R> AutoCompleteTextView initAutoCompleteTextView(int autoCompleteTextViewId, String attribute, Collection<R> data, Collection<R> favorites) {
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.findViewById(autoCompleteTextViewId);
        this.initAutoCompleteTextView(autoCompleteTextView, attribute, data, favorites);
        return autoCompleteTextView;
    }

    protected <R> void initAutoCompleteTextView(AutoCompleteTextView autoCompleteTextView, String attribute, Collection<R> data) {
        this.initAutoCompleteTextView(autoCompleteTextView, attribute, data, null);
    }

    protected <R> void initAutoCompleteTextView(final AutoCompleteTextView autoCompleteTextView, String attribute, Collection<R> data, Collection<R> favorites) {
        final Class<?> clazz = this.model.getClass();
        final String firtsLetterUpperCaseAttribute = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
        if (!data.isEmpty()) {
            WloAutoCompleteTextViewWithFavorites.FavoriteAdapter<R> adapter = new WloAutoCompleteTextViewWithFavorites.FavoriteAdapter<R>((Context)this, data, favorites);
            autoCompleteTextView.setAdapter(adapter);
        }
        autoCompleteTextView.setThreshold(0);
        autoCompleteTextView.setTag((Object)attribute);
        autoCompleteTextView.addTextChangedListener((TextWatcher)new BaseTextWatcher(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                autoCompleteTextView.setError(null);
                autoCompleteTextView.setSelection(start + count);
            }
        });
        try {
            Object value = clazz.getMethod("get" + firtsLetterUpperCaseAttribute, new Class[0]).invoke(this.model, new Object[0]);
            if (value != null) {
                String text = value.toString();
                autoCompleteTextView.setText((CharSequence)text);
                autoCompleteTextView.dismissDropDown();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)("Error on get" + firtsLetterUpperCaseAttribute + " for class " + clazz), (Throwable)e);
        }
        autoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object selectedData = parent.getItemAtPosition(position);
                Log.d((String)WloModelEditionActivity.TAG, (String)("selectedData.getClass() " + selectedData.getClass()));
                try {
                    clazz.getMethod("set" + firtsLetterUpperCaseAttribute, selectedData.getClass()).invoke(WloModelEditionActivity.this.model, selectedData);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Log.e((String)WloModelEditionActivity.TAG, (String)("Error on set" + firtsLetterUpperCaseAttribute + " for class " + clazz), (Throwable)e);
                }
            }
        });
        this.addModelPropertyChangeListener((EditText)autoCompleteTextView, attribute, false);
    }

    protected void addModelPropertyChangeListener(final EditText editText, String property, final boolean checkFocus) {
        ((BaseModel)this.model).addPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!checkFocus || !editText.isFocused()) {
                    Object newValue = event.getNewValue();
                    String text = newValue != null ? newValue.toString() : WloModelEditionActivity.this.getString(2131427374);
                    editText.setText((CharSequence)text);
                }
            }
        });
    }

    protected void openNewModelEdition() {
        Intent intent = new Intent((Context)this, ((Object)((Object)this)).getClass());
        if (HierarchicalModel.class.isAssignableFrom(this.model.getClass())) {
            HierarchicalModel hModel = (HierarchicalModel)this.model;
            Object parentModel = hModel.getParent();
            intent.putExtra(INTENT_EXTRA_PARENT_MODEL, parentModel);
        }
        this.startActivity(intent);
    }
}

