/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.widget.DrawerLayout;
import android.support.v4.widget.SimpleCursorAdapter;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.CommercialSpeciesActivity;
import fr.ifremer.wlo.CommercialSpeciesFormActivity;
import fr.ifremer.wlo.ContextFormActivity;
import fr.ifremer.wlo.ContextsActivity;
import fr.ifremer.wlo.LocationFormActivity;
import fr.ifremer.wlo.LocationsActivity;
import fr.ifremer.wlo.MainActivity;
import fr.ifremer.wlo.MetierFormActivity;
import fr.ifremer.wlo.MetiersActivity;
import fr.ifremer.wlo.ScientificSpeciesActivity;
import fr.ifremer.wlo.ScientificSpeciesFormActivity;
import fr.ifremer.wlo.VesselFormActivity;
import fr.ifremer.wlo.VesselsActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloModelEditionActivity;
import fr.ifremer.wlo.models.BaseModel;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ContextModel;
import fr.ifremer.wlo.models.HierarchicalModel;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.models.MetierModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.VesselModel;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.UIUtils;
import fr.ifremer.wlo.utils.WloItemListViewBinder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class WloBaseListActivity<M extends BaseModel>
extends WloBaseActivity {
    private static final String TAG = "WloBaseListActivity";
    public static final String INTENT_EXTRA_PARENT_MODEL = "parentModel";
    public static final int REQUEST_EDIT_MODEL = 0;
    protected static final Map<Class, BaseModel> drawerItems = new LinkedHashMap<Class, BaseModel>();
    protected BaseModel parentModel;
    protected WloSqlOpenHelper woh;
    protected SimpleCursorAdapter adapter;
    protected ActionBarDrawerToggle mDrawerToggle;
    protected ListView mDrawerList;
    protected ListView mList;
    private Handler mHandler = new Handler();
    private boolean mFinishedStart = false;
    private Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            WloBaseListActivity.this.mList.focusableViewAvailable((View)WloBaseListActivity.this.mList);
        }
    };
    private AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView parent, View v, int position, long id2) {
            WloBaseListActivity.this.onListItemClick((ListView)parent, v, position, id2);
        }
    };

    protected abstract SimpleCursorAdapter createAdapter();

    protected abstract Cursor getAllData();

    protected abstract M createNewModel(Cursor var1);

    protected M createNewModel(AdapterView l, int position) {
        Cursor cursor = (Cursor)l.getItemAtPosition(position);
        M model = this.createNewModel(cursor);
        if (HierarchicalModel.class.isAssignableFrom(model.getClass())) {
            HierarchicalModel hModel = (HierarchicalModel)model;
            hModel.setParent(this.parentModel);
        }
        return model;
    }

    protected abstract Class<? extends WloBaseActivity> getNextActivity();

    protected abstract Class<? extends WloModelEditionActivity> getEditionActivity();

    protected abstract Integer getSubtitle();

    @Override
    protected Integer getContentView() {
        return 2130903092;
    }

    protected SimpleCursorAdapter.ViewBinder getAdapterBinder() {
        return new WloItemListViewBinder((Context)this);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.woh = new WloSqlOpenHelper((Context)this);
        this.adapter = this.createAdapter();
        this.adapter.setViewBinder(this.getAdapterBinder());
        this.setListAdapter(this.adapter);
        this.registerForContextMenu((View)this.mList);
        DrawerLayout mDrawerLayout = (DrawerLayout)this.findViewById(2131099755);
        this.mDrawerList = (ListView)this.findViewById(2131099773);
        this.mDrawerList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView parent, View view, int position, long id2) {
                WloBaseListActivity.this.selectItem(position);
            }
        });
        this.mDrawerList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                WloBaseListActivity.this.editItem(position);
                return true;
            }
        });
        this.mDrawerToggle = new ActionBarDrawerToggle((Activity)this, mDrawerLayout, 2130837597, 2131427358, 2131427359);
        mDrawerLayout.setDrawerListener((DrawerLayout.DrawerListener)this.mDrawerToggle);
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setHomeButtonEnabled(true);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mDrawerToggle.syncState();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.parentModel = (BaseModel)this.getIntent().getSerializableExtra(INTENT_EXTRA_PARENT_MODEL);
        Log.d((String)TAG, (String)("resume " + this.parentModel));
        if (this.parentModel != null) {
            Cursor cursor = this.getAllData();
            Log.d((String)TAG, (String)("cursor size : " + cursor.getCount()));
            this.adapter.swapCursor(cursor);
            Integer subtitleId = this.getSubtitle();
            if (subtitleId != null) {
                String subtitle = this.getString(subtitleId, new Object[]{this.parentModel.toString((Context)this)});
                this.getSupportActionBar().setSubtitle((CharSequence)subtitle);
            }
        }
        this.setDrawerListAdapter();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.woh.close();
    }

    @Override
    public Intent getSupportParentActivityIntent() {
        Intent intent = super.getSupportParentActivityIntent();
        if (intent != null && this.parentModel != null && HierarchicalModel.class.isAssignableFrom(this.parentModel.getClass())) {
            HierarchicalModel hParentModel = (HierarchicalModel)this.parentModel;
            intent.putExtra(INTENT_EXTRA_PARENT_MODEL, hParentModel.getParent());
        }
        return intent;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131623937, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.mDrawerToggle.onOptionsItemSelected(item)) {
            return true;
        }
        switch (item.getItemId()) {
            case 2131099800: {
                Intent intent = new Intent((Context)this, this.getEditionActivity());
                intent.putExtra(INTENT_EXTRA_PARENT_MODEL, (Serializable)this.parentModel);
                this.startActivity(intent);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDrawerToggle.onConfigurationChanged(newConfig);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            BaseModel editedModel = (BaseModel)data.getSerializableExtra("model");
            if (editedModel != null) {
                drawerItems.put(editedModel.getClass(), editedModel);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void setDrawerListAdapter() {
        ArrayList<String> drawerItemsLabels = new ArrayList<String>();
        drawerItemsLabels.add(this.getString(2131427360));
        ArrayList<BaseModel> values = new ArrayList<BaseModel>(drawerItems.values());
        drawerItemsLabels.addAll(Lists.transform(values, (Function)new Function<BaseModel, String>(){

            public String apply(BaseModel input) {
                return input.toString((Context)WloBaseListActivity.this);
            }
        }));
        this.mDrawerList.setAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, drawerItemsLabels));
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        M model = this.createNewModel((AdapterView)l, position);
        Log.d((String)TAG, (String)(((BaseModel)model).toString((Context)this) + " clicked"));
        this.updateDrawerItems(model);
        Intent intent = new Intent((Context)this, this.getNextActivity());
        intent.putExtra(INTENT_EXTRA_PARENT_MODEL, model);
        this.startActivity(intent);
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.mList.equals(v)) {
            int[] menuItems = new int[]{2131427347, 2131427346};
            for (int i = 0; i < menuItems.length; ++i) {
                menu2.add(0, i, i, menuItems[i]);
            }
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        AdapterView parent = (AdapterView)info.targetView.getParent();
        M model = this.createNewModel(parent, info.position);
        switch (item.getItemId()) {
            case 0: {
                Intent intent = new Intent((Context)this, this.getEditionActivity());
                intent.putExtra("model", model);
                this.startActivity(intent);
                break;
            }
            case 1: {
                new AlertDialog.Builder((Context)this).setTitle(2131427368).setMessage((CharSequence)this.getString(2131427371, new Object[]{((BaseModel)model).toString((Context)this)})).setPositiveButton(2131427346, new DialogInterface.OnClickListener((BaseModel)model){
                    final /* synthetic */ BaseModel val$model;
                    {
                        this.val$model = baseModel;
                    }

                    public void onClick(DialogInterface dialog, int which) {
                        WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)WloBaseListActivity.this);
                        soh.deleteData(this.val$model);
                        soh.close();
                        Cursor cursor = WloBaseListActivity.this.getAllData();
                        WloBaseListActivity.this.adapter.swapCursor(cursor);
                    }
                }).setNegativeButton(0x1040000, UIUtils.getCancelClickListener()).create().show();
            }
        }
        return true;
    }

    protected void onRestoreInstanceState(Bundle state) {
        this.ensureList();
        super.onRestoreInstanceState(state);
    }

    public void onSupportContentChanged() {
        super.onSupportContentChanged();
        View emptyView = this.findViewById(16908292);
        this.mList = (ListView)this.findViewById(16908298);
        if (this.mList == null) {
            throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
        }
        if (emptyView != null) {
            this.mList.setEmptyView(emptyView);
        }
        this.mList.setOnItemClickListener(this.mOnClickListener);
        if (this.mFinishedStart) {
            this.setListAdapter(this.adapter);
        }
        this.mHandler.post(this.mRequestFocus);
        this.mFinishedStart = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListAdapter(SimpleCursorAdapter adapter) {
        WloBaseListActivity wloBaseListActivity = this;
        synchronized (wloBaseListActivity) {
            this.ensureList();
            this.adapter = adapter;
            this.mList.setAdapter((ListAdapter)adapter);
        }
    }

    public void setSelection(int position) {
        this.mList.setSelection(position);
    }

    public int getSelectedItemPosition() {
        return this.mList.getSelectedItemPosition();
    }

    public long getSelectedItemId() {
        return this.mList.getSelectedItemId();
    }

    public ListView getListView() {
        this.ensureList();
        return this.mList;
    }

    public ListAdapter getListAdapter() {
        return this.adapter;
    }

    private void ensureList() {
        if (this.mList != null) {
            return;
        }
        this.setContentView(17367060);
    }

    protected void updateDrawerItems(M model) {
        Class<?> itemClass = model.getClass();
        BaseModel currentItem = drawerItems.get(itemClass);
        if (!((BaseModel)model).equals(currentItem)) {
            String itemTable;
            drawerItems.put(itemClass, (BaseModel)model);
            switch (itemTable = ((BaseModel)model).getTableName()) {
                case "contexts": {
                    drawerItems.remove(LocationModel.class);
                }
                case "locations": {
                    drawerItems.remove(VesselModel.class);
                }
                case "vessels": {
                    drawerItems.remove(MetierModel.class);
                }
                case "metiers": {
                    drawerItems.remove(CommercialSpeciesModel.class);
                }
                case "commercial_species": {
                    drawerItems.remove(ScientificSpeciesModel.class);
                }
            }
        }
    }

    protected void selectItem(int position) {
        Class activityClass;
        Class parentModelClass = null;
        switch (position) {
            case 0: {
                activityClass = MainActivity.class;
                break;
            }
            case 1: {
                activityClass = ContextsActivity.class;
                break;
            }
            case 2: {
                activityClass = LocationsActivity.class;
                parentModelClass = ContextModel.class;
                break;
            }
            case 3: {
                activityClass = VesselsActivity.class;
                parentModelClass = LocationModel.class;
                break;
            }
            case 4: {
                activityClass = MetiersActivity.class;
                parentModelClass = VesselModel.class;
                break;
            }
            case 5: {
                activityClass = CommercialSpeciesActivity.class;
                parentModelClass = MetierModel.class;
                break;
            }
            case 6: {
                activityClass = ScientificSpeciesActivity.class;
                parentModelClass = CommercialSpeciesModel.class;
                break;
            }
            default: {
                activityClass = null;
            }
        }
        BaseModel parentModel = drawerItems.get(parentModelClass);
        Intent intent = new Intent((Context)this, activityClass);
        intent.putExtra(INTENT_EXTRA_PARENT_MODEL, (Serializable)parentModel);
        this.startActivity(intent);
    }

    protected void editItem(int position) {
        Class activityClass = null;
        Class modelClass = null;
        switch (position) {
            case 1: {
                activityClass = ContextFormActivity.class;
                modelClass = ContextModel.class;
                break;
            }
            case 2: {
                activityClass = LocationFormActivity.class;
                modelClass = LocationModel.class;
                break;
            }
            case 3: {
                activityClass = VesselFormActivity.class;
                modelClass = VesselModel.class;
                break;
            }
            case 4: {
                activityClass = MetierFormActivity.class;
                modelClass = MetierModel.class;
                break;
            }
            case 5: {
                activityClass = CommercialSpeciesFormActivity.class;
                modelClass = CommercialSpeciesModel.class;
                break;
            }
            case 6: {
                activityClass = ScientificSpeciesFormActivity.class;
                modelClass = ScientificSpeciesModel.class;
            }
        }
        if (activityClass != null) {
            BaseModel model = drawerItems.get(modelClass);
            Intent intent = new Intent((Context)this, activityClass);
            intent.putExtra("model", (Serializable)model);
            this.startActivityForResult(intent, 0);
        }
    }
}

