/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.wlo.ScientificSpeciesActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloBaseListActivity;
import fr.ifremer.wlo.WloModelEditionActivity;
import fr.ifremer.wlo.measurement.MeasurementActivity;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.models.referentials.ScientificSpecies;
import fr.ifremer.wlo.preferences.MultiSelectItemPreference;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.WloAutoCompleteTextViewWithFavorites;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class ScientificSpeciesFormActivity
extends WloModelEditionActivity<ScientificSpeciesModel> {
    private static final String TAG = "ScientificSpeciesFormActivity";

    @Override
    protected Integer getContentView() {
        return 2130903085;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return ScientificSpeciesActivity.class;
    }

    @Override
    protected Class<? extends WloModelEditionActivity> getNextEditionActivity() {
        return null;
    }

    @Override
    protected Class<? extends WloBaseListActivity> getNextListActivity() {
        return null;
    }

    @Override
    protected ScientificSpeciesModel createNewModel() {
        return new ScientificSpeciesModel();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"on create");
        super.onCreate(savedInstanceState);
        ArrayList scientificSpecies = Lists.newArrayList(DataCache.getAllScientificSpecies((Context)this));
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        final Set favoriteIds = sharedPref.getStringSet(MultiSelectItemPreference.SCIENTIFIC_SPECIES_FAVORITES.getKey(), (Set)Sets.newHashSet());
        Collection favorites = Collections2.filter((Collection)scientificSpecies, (Predicate)new Predicate<ScientificSpecies>(){

            public boolean apply(ScientificSpecies input) {
                return favoriteIds.contains(input.getId());
            }
        });
        WloAutoCompleteTextViewWithFavorites actvwf = (WloAutoCompleteTextViewWithFavorites)this.findViewById(2131099788);
        this.initAutoCompleteTextView(actvwf.getAutoCompleteTextView(), "name", scientificSpecies, favorites);
        actvwf.useFavorites(!favorites.isEmpty());
        CheckBox takingActivationEditor = (CheckBox)this.findViewById(2131099789);
        takingActivationEditor.setChecked(((ScientificSpeciesModel)this.model).isTakingActivation());
        takingActivationEditor.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                ((ScientificSpeciesModel)ScientificSpeciesFormActivity.this.model).setTakingActivation(b);
            }
        });
        this.initEditText(2131099723, "comment");
    }

    @Override
    public void validate(View view) {
        boolean newModel = ((ScientificSpeciesModel)this.model).isNew();
        WloSqlOpenHelper woh = new WloSqlOpenHelper((Context)this);
        woh.saveData(this.model);
        woh.close();
        if (newModel) {
            Intent intent = new Intent((Context)this, MeasurementActivity.class);
            intent.putExtra("scientificSpecies", (Serializable)this.model);
            this.startActivity(intent);
        } else {
            this.finish();
        }
    }
}

