/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.support.v4.widget.SimpleCursorAdapter;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import com.google.common.collect.Maps;
import fr.ifremer.wlo.CommercialSpeciesActivity;
import fr.ifremer.wlo.ScientificSpeciesFormActivity;
import fr.ifremer.wlo.WeightsActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloBaseListActivity;
import fr.ifremer.wlo.WloModelEditionActivity;
import fr.ifremer.wlo.measurement.MeasurementActivity;
import fr.ifremer.wlo.models.CommercialSpeciesModel;
import fr.ifremer.wlo.models.ScientificSpeciesModel;
import fr.ifremer.wlo.utils.WloItemListViewBinder;
import java.io.Serializable;
import java.util.HashMap;

public class ScientificSpeciesActivity
extends WloBaseListActivity<ScientificSpeciesModel> {
    private static final String TAG = "ScientificSpeciesActivity";

    @Override
    protected SimpleCursorAdapter createAdapter() {
        return new SimpleCursorAdapter((Context)this, 17367043, null, new String[]{"name"}, new int[]{16908308}, 0);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        CommercialSpeciesModel parent = (CommercialSpeciesModel)this.parentModel;
        MenuInflater inflater = this.getMenuInflater();
        if (parent != null && parent.isSpeciesMix() || this.adapter.getCount() == 0) {
            inflater.inflate(2131623937, menu2);
        }
        inflater.inflate(2131623938, menu2);
        return true;
    }

    @Override
    protected Cursor getAllData() {
        Cursor cursor = this.woh.getAllScientificSpecies(this.parentModel.getId());
        return cursor;
    }

    @Override
    protected ScientificSpeciesModel createNewModel(Cursor cursor) {
        return new ScientificSpeciesModel((Context)this, cursor);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131099801: {
                Intent intent = new Intent((Context)this, WeightsActivity.class);
                intent.putExtra("commercialSpecies", (Serializable)this.parentModel);
                this.startActivity(intent);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected Class<? extends WloModelEditionActivity> getEditionActivity() {
        return ScientificSpeciesFormActivity.class;
    }

    @Override
    protected Integer getSubtitle() {
        return 2131427471;
    }

    @Override
    protected Class<? extends WloBaseActivity> getNextActivity() {
        return MeasurementActivity.class;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return CommercialSpeciesActivity.class;
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id2) {
        ScientificSpeciesModel model = (ScientificSpeciesModel)this.createNewModel((AdapterView)l, position);
        Log.d((String)TAG, (String)(model.toString((Context)this) + " clicked"));
        this.updateDrawerItems(model);
        Intent intent = new Intent((Context)this, this.getNextActivity());
        intent.putExtra("scientificSpecies", (Serializable)model);
        this.startActivity(intent);
    }

    @Override
    protected SimpleCursorAdapter.ViewBinder getAdapterBinder() {
        HashMap types = Maps.newHashMap();
        types.put(1, WloItemListViewBinder.DataType.SCIENTIFIC_SPECIES);
        return new WloItemListViewBinder((Context)this, types);
    }
}

