/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;
import fr.ifremer.wlo.ContextsActivity;
import fr.ifremer.wlo.DeviceListActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.models.categorization.CategoryModel;
import fr.ifremer.wlo.preferences.SettingsActivity;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.storage.Exporter;
import fr.ifremer.wlo.storage.WloSqlOpenHelper;
import fr.ifremer.wlo.utils.ImportUtil;
import fr.ifremer.wlo.utils.UpdateCheckTask;
import fr.ifremer.wlo.utils.filechooser.FileDialog;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;

public class MainActivity
extends WloBaseActivity {
    private static final String TAG = "MainActivity";
    protected static final int REQUEST_ENABLE_BT = 1;
    protected static final int REQUEST_CONNECT_ICHTYOMETER = 2;
    protected static final int REQUEST_SELECT_EXPORT_FOLDER = 3;
    protected BluetoothAdapter mBluetoothAdapter = null;
    protected LinearLayout mainPanel;
    protected LinearLayout logoPanel;
    protected LinearLayout buttonPanel;
    protected Button connectButton;
    protected Button disconnectButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"create");
        this.mMessenger = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        switch (msg.arg1) {
                            case 3: {
                                MainActivity.this.bigfinConnected();
                                break;
                            }
                            case 0: 
                            case 1: {
                                MainActivity.this.bigfinDisconnected();
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 6: {
                        MainActivity.this.bigfinDisconnected();
                    }
                }
            }
        });
        super.onCreate(savedInstanceState);
        new InitializationTask().execute(new Void[0]);
        new UpdateCheckTask((Context)this).execute(new String[0]);
        this.mainPanel = (LinearLayout)this.findViewById(2131099750);
        this.logoPanel = (LinearLayout)this.findViewById(2131099751);
        this.buttonPanel = (LinearLayout)this.findViewById(2131099752);
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            this.findViewById(2131099753).setEnabled(false);
        }
        this.connectButton = (Button)this.findViewById(2131099753);
        this.disconnectButton = (Button)this.findViewById(2131099754);
        this.bigfinDisconnected();
        Configuration config = this.getResources().getConfiguration();
        this.setOrientation(config.orientation);
    }

    protected void bigfinConnected() {
        this.disconnectButton.setVisibility(0);
        this.connectButton.setVisibility(8);
    }

    protected void bigfinDisconnected() {
        this.connectButton.setVisibility(0);
        this.disconnectButton.setVisibility(8);
    }

    @Override
    protected Integer getContentView() {
        return 2130903075;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setOrientation(newConfig.orientation);
    }

    public void openContexts(View source) {
        this.startActivity(new Intent((Context)this, ContextsActivity.class));
    }

    public void connectIchtyometer(View source) {
        if (!this.mBluetoothAdapter.isEnabled()) {
            Intent enableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.startActivityForResult(enableIntent, 1);
        } else {
            this.selectDevice();
        }
    }

    public void disconnectIchtyometer(View source) {
        Message message = Message.obtain(null, (int)5);
        try {
            this.mServiceMessenger.send(message);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error while sending data to the service");
        }
    }

    public void openSettings(View source) {
        this.startActivity(new Intent((Context)this, SettingsActivity.class));
    }

    public void export(View source) {
        Intent intent = new Intent((Context)this, FileDialog.class);
        intent.putExtra("START_PATH", "/sdcard");
        intent.putExtra("CAN_SELECT_DIR", true);
        intent.putExtra("SELECTION_MODE", 1);
        intent.putExtra("FORMAT_FILTER", new String[]{"json"});
        this.startActivityForResult(intent, 3);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 2: {
                break;
            }
            case 1: {
                if (resultCode == -1) {
                    this.selectDevice();
                    break;
                }
                Log.d((String)TAG, (String)"BT not enabled");
                Toast.makeText((Context)this, (int)2131427356, (int)0).show();
                break;
            }
            case 3: {
                if (resultCode != -1) break;
                try {
                    String jsonData = Exporter.exportData((Context)this);
                    File selectedFile = new File(data.getStringExtra("RESULT_PATH"));
                    if (selectedFile.isFile()) {
                        selectedFile = selectedFile.getParentFile();
                    }
                    String date = String.format("-%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", new Date());
                    File file = new File(selectedFile, "export" + date + ".json");
                    FileUtils.write((File)file, (CharSequence)jsonData);
                    Toast.makeText((Context)this, (CharSequence)("Export effectu\u00e9 dans le fichier " + file.getAbsolutePath()), (int)1).show();
                    break;
                }
                catch (IOException | JSONException e) {
                    Log.e((String)TAG, (String)"error while exporting to JSON", (Throwable)e);
                    Toast.makeText((Context)this, (CharSequence)"Erreur lors de l'export", (int)0).show();
                }
            }
        }
    }

    protected void setOrientation(int orientation) {
        LinearLayout.LayoutParams buttonParams;
        LinearLayout.LayoutParams logoParams;
        if (orientation == 2) {
            logoParams = new LinearLayout.LayoutParams(-2, -1);
            logoParams.weight = 1.0f;
            buttonParams = new LinearLayout.LayoutParams(-2, -1);
            buttonParams.weight = 1.0f;
        } else {
            logoParams = new LinearLayout.LayoutParams(-1, -2);
            logoParams.weight = 1.0f;
            buttonParams = new LinearLayout.LayoutParams(-1, -2);
            buttonParams.weight = 0.0f;
        }
        this.logoPanel.setLayoutParams((ViewGroup.LayoutParams)logoParams);
        this.buttonPanel.setLayoutParams((ViewGroup.LayoutParams)buttonParams);
        this.mainPanel.setOrientation(orientation);
    }

    protected void selectDevice() {
        Intent serverIntent = new Intent((Context)this, DeviceListActivity.class);
        this.startActivityForResult(serverIntent, 2);
    }

    protected class InitializationTask
    extends AsyncTask<Void, Integer, Void> {
        protected ProgressDialog dialog;

        protected InitializationTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog = new ProgressDialog((Context)MainActivity.this);
            this.dialog.setIndeterminate(false);
            this.dialog.setCancelable(false);
            this.dialog.setProgressStyle(1);
            this.dialog.setMax(9);
            this.dialog.setMessage((CharSequence)MainActivity.this.getString(2131427383));
            this.dialog.show();
        }

        protected Void doInBackground(Void ... params) {
            MainActivity context = MainActivity.this;
            try {
                int i = 1;
                if (DataCache.getAllCommercialSpecies((Context)context).isEmpty()) {
                    ImportUtil.importCommercialSpecies((Context)context, MainActivity.this.getAssets().open("ref_import_commercial_species.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllLocations((Context)context).isEmpty()) {
                    ImportUtil.importLocations((Context)context, MainActivity.this.getAssets().open("ref_import_locations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllMensurations((Context)context).isEmpty()) {
                    ImportUtil.importMensurations((Context)context, MainActivity.this.getAssets().open("ref_import_mensurations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllMetiers((Context)context).isEmpty()) {
                    ImportUtil.importMetiers((Context)context, MainActivity.this.getAssets().open("ref_import_metiers.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllPresentations((Context)context).isEmpty()) {
                    ImportUtil.importPresentations((Context)context, MainActivity.this.getAssets().open("ref_import_presentations.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllScientificSpecies((Context)context).isEmpty()) {
                    ImportUtil.importScientificSpecies((Context)context, MainActivity.this.getAssets().open("ref_import_scientific_species.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllStates((Context)context).isEmpty()) {
                    ImportUtil.importStates((Context)context, MainActivity.this.getAssets().open("ref_import_states.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllVessels((Context)context).isEmpty()) {
                    ImportUtil.importVessels((Context)context, MainActivity.this.getAssets().open("ref_import_vessels.csv"));
                }
                this.publishProgress(new Integer[]{i++});
                if (DataCache.getAllCategories((Context)context).isEmpty()) {
                    WloSqlOpenHelper soh = new WloSqlOpenHelper((Context)context);
                    CategoryModel ageCategory = new CategoryModel();
                    ageCategory.setLabel(MainActivity.this.getString(2131427366));
                    soh.saveData(ageCategory);
                    CategoryModel genderCategory = new CategoryModel();
                    genderCategory.setLabel(MainActivity.this.getString(2131427364));
                    soh.saveData(genderCategory);
                    CategoryModel maturityCategory = new CategoryModel();
                    maturityCategory.setLabel(MainActivity.this.getString(2131427365));
                    soh.saveData(maturityCategory);
                    soh.saveData(ImportUtil.importQualitativeValues(ageCategory, MainActivity.this.getAssets().open("ref_import_ages.csv")));
                    soh.saveData(ImportUtil.importQualitativeValues(genderCategory, MainActivity.this.getAssets().open("ref_import_genders.csv")));
                    soh.saveData(ImportUtil.importQualitativeValues(maturityCategory, MainActivity.this.getAssets().open("ref_import_maturities.csv")));
                    soh.close();
                }
                this.publishProgress(new Integer[]{i++});
            }
            catch (IOException | RuntimeException e) {
                Log.e((String)MainActivity.TAG, (String)"error on initial import", (Throwable)e);
            }
            return null;
        }

        protected void onProgressUpdate(Integer ... progress) {
            this.dialog.setProgress(progress[0].intValue());
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            this.dialog.dismiss();
        }
    }
}

