/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.google.common.collect.Lists;
import fr.ifremer.wlo.LocationsActivity;
import fr.ifremer.wlo.VesselFormActivity;
import fr.ifremer.wlo.VesselsActivity;
import fr.ifremer.wlo.WloBaseActivity;
import fr.ifremer.wlo.WloBaseListActivity;
import fr.ifremer.wlo.WloModelEditionActivity;
import fr.ifremer.wlo.models.LocationModel;
import fr.ifremer.wlo.preferences.StringPreference;
import fr.ifremer.wlo.storage.DataCache;
import fr.ifremer.wlo.utils.DatePickerFragment;
import fr.ifremer.wlo.utils.TimePickerFragment;
import fr.ifremer.wlo.utils.UIUtils;
import java.util.ArrayList;
import java.util.Calendar;

public class LocationFormActivity
extends WloModelEditionActivity<LocationModel> {
    private static final String TAG = "LocationFormActivity";

    @Override
    protected Integer getContentView() {
        return 2130903073;
    }

    @Override
    protected Class<? extends WloBaseActivity> getUpActivity() {
        return LocationsActivity.class;
    }

    @Override
    protected Class<? extends WloModelEditionActivity> getNextEditionActivity() {
        return VesselFormActivity.class;
    }

    @Override
    protected Class<? extends WloBaseListActivity> getNextListActivity() {
        return VesselsActivity.class;
    }

    @Override
    protected LocationModel createNewModel() {
        return new LocationModel();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Calendar endDate;
        Log.d((String)TAG, (String)"on create");
        super.onCreate(savedInstanceState);
        String defaultOperator = null;
        if (((LocationModel)this.model).isNew()) {
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            defaultOperator = sharedPref.getString(StringPreference.DEFAULT_OPERATOR.getKey(), null);
        }
        this.initEditText(2131099746, "operator", defaultOperator);
        ArrayList locations = Lists.newArrayList(DataCache.getAllLocations((Context)this));
        this.initAutoCompleteTextView(2131099741, "location", locations);
        TextView startDateTextView = (TextView)this.findViewById(2131099742);
        TextView startTimeTextView = (TextView)this.findViewById(2131099743);
        TextView endDateTextView = (TextView)this.findViewById(2131099744);
        TextView endTimeTextView = (TextView)this.findViewById(2131099745);
        String dateFormat = UIUtils.getDateFormat((Context)this);
        Calendar startDate = ((LocationModel)this.model).getStartDate();
        if (startDate != null) {
            startDateTextView.setText((CharSequence)String.format(dateFormat, startDate.getTime()));
            startTimeTextView.setText((CharSequence)this.getString(2131427373, new Object[]{startDate.getTime()}));
        }
        if ((endDate = ((LocationModel)this.model).getEndDate()) != null) {
            endDateTextView.setText((CharSequence)String.format(dateFormat, endDate.getTime()));
            endTimeTextView.setText((CharSequence)this.getString(2131427373, new Object[]{endDate.getTime()}));
        }
        this.initEditText(2131099723, "comment");
    }

    public void pickDate(View v) {
        String attribute;
        switch (v.getId()) {
            case 2131099742: {
                attribute = "startDate";
                break;
            }
            case 2131099744: {
                attribute = "endDate";
                break;
            }
            default: {
                return;
            }
        }
        DatePickerFragment newFragment = new DatePickerFragment(this.model, attribute, (TextView)v);
        newFragment.show(this.getSupportFragmentManager(), "datePicker");
    }

    public void pickTime(View v) {
        String attribute;
        switch (v.getId()) {
            case 2131099743: {
                attribute = "startDate";
                break;
            }
            case 2131099745: {
                attribute = "endDate";
                break;
            }
            default: {
                return;
            }
        }
        TimePickerFragment newFragment = new TimePickerFragment(this.model, attribute, (TextView)v);
        newFragment.show(this.getSupportFragmentManager(), "timePicker");
    }
}

