/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wlo;

import android.app.ListActivity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import fr.ifremer.wlo.BigFinCommunicationService;
import fr.ifremer.wlo.utils.BigFinFeedReaderRecord;
import java.util.Set;

public class DeviceListActivity
extends ListActivity
implements ServiceConnection {
    private static final String TAG = "DeviceListActivity";
    public static final String EXTRA_DEVICE_ADDRESS = "device_address";
    protected BluetoothAdapter mBtAdapter;
    protected ArrayAdapter<String> mPairedDevicesArrayAdapter;
    protected Messenger mServiceMessenger = null;
    protected Messenger mMessenger = new Messenger((Handler)new IncomingHandler());
    protected AdapterView.OnItemClickListener mDeviceClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> av, View v, int arg2, long arg3) {
            DeviceListActivity.this.mBtAdapter.cancelDiscovery();
            String info = ((TextView)v).getText().toString();
            String address = info.substring(info.length() - 17);
            Message message = Message.obtain(null, (int)3);
            Bundle bundle = new Bundle();
            bundle.putString(DeviceListActivity.EXTRA_DEVICE_ADDRESS, address);
            message.setData(bundle);
            try {
                DeviceListActivity.this.mServiceMessenger.send(message);
            }
            catch (RemoteException e) {
                Log.e((String)DeviceListActivity.TAG, (String)"Error while sending data to the service");
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903068);
        this.mPairedDevicesArrayAdapter = new ArrayAdapter((Context)this, 2130903069);
        ListView pairedListView = this.getListView();
        pairedListView.setAdapter(this.mPairedDevicesArrayAdapter);
        pairedListView.setOnItemClickListener(this.mDeviceClickListener);
        this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        Set pairedDevices = this.mBtAdapter.getBondedDevices();
        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                this.mPairedDevicesArrayAdapter.add((Object)(device.getName() + "\n" + device.getAddress()));
            }
        }
        this.bindService(new Intent((Context)this, BigFinCommunicationService.class), this, 1);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mBtAdapter != null) {
            this.mBtAdapter.cancelDiscovery();
        }
        this.doUnbindService();
    }

    protected void doUnbindService() {
        if (this.mServiceMessenger != null) {
            try {
                Message msg = Message.obtain(null, (int)2);
                msg.replyTo = this.mMessenger;
                this.mServiceMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error while sending data to the service");
            }
        }
        this.unbindService(this);
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mServiceMessenger = new Messenger(service);
        try {
            Message msg = Message.obtain(null, (int)1);
            msg.replyTo = this.mMessenger;
            this.mServiceMessenger.send(msg);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error while sending data to the service");
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.mServiceMessenger = null;
    }

    protected void sendDataToDevice(String data) {
        Message message = Message.obtain(null, (int)4);
        Bundle bundle = new Bundle();
        bundle.putString("dataToSend", data);
        message.setData(bundle);
        try {
            this.mServiceMessenger.send(message);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error while sending data to the service");
        }
    }

    class IncomingHandler
    extends Handler {
        ProgressDialog dialog;

        IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    switch (msg.arg1) {
                        case 3: {
                            DeviceListActivity.this.sendDataToDevice("a");
                            DeviceListActivity.this.sendDataToDevice("b");
                            this.dialog.dismiss();
                            DeviceListActivity.this.finish();
                            break;
                        }
                        case 2: {
                            this.dialog = ProgressDialog.show((Context)DeviceListActivity.this, (CharSequence)"", (CharSequence)"Connecting. Please wait...", (boolean)true);
                        }
                    }
                    break;
                }
                case 3: {
                    byte[] writeBuf = (byte[])msg.obj;
                    String writeMessage = new String(writeBuf);
                    Log.d((String)DeviceListActivity.TAG, (String)("write " + writeMessage));
                    break;
                }
                case 2: {
                    BigFinFeedReaderRecord record = (BigFinFeedReaderRecord)msg.obj;
                    Log.d((String)DeviceListActivity.TAG, (String)("read " + record.getLength()));
                    break;
                }
                case 4: {
                    String mConnectedDeviceName = msg.getData().getString("device_name");
                    Toast.makeText((Context)DeviceListActivity.this.getApplicationContext(), (CharSequence)("Connected to " + mConnectedDeviceName), (int)0).show();
                    break;
                }
                case 5: 
                case 6: {
                    if (this.dialog != null) {
                        this.dialog.dismiss();
                    }
                    Toast.makeText((Context)DeviceListActivity.this.getApplicationContext(), (CharSequence)msg.getData().getString("toast"), (int)0).show();
                }
            }
        }
    }
}

