/*
 * Decompiled with CFR 0.152.
 */
package winstone.realm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;

public class ArgumentsRealm
implements AuthenticationRealm {
    private static final WinstoneResourceBundle REALM_RESOURCES = new WinstoneResourceBundle("winstone.realm.LocalStrings");
    static final String PASSWORD_PREFIX = "argumentsRealm.passwd.";
    static final String ROLES_PREFIX = "argumentsRealm.roles.";
    private Map passwords = new Hashtable();
    private Map roles = new Hashtable();

    public ArgumentsRealm(Set rolesAllowed, Map args) {
        Iterator i = args.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(PASSWORD_PREFIX)) continue;
            String userName = key.substring(PASSWORD_PREFIX.length());
            String password = (String)args.get(key);
            String roleList = WebAppConfiguration.stringArg(args, ROLES_PREFIX + userName, "");
            if (roleList.equals("")) {
                Logger.log(Logger.WARNING, REALM_RESOURCES, "ArgumentsRealm.UndeclaredRoles", userName);
            } else {
                StringTokenizer st = new StringTokenizer(roleList, ",");
                ArrayList<String> rl = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String currentRole = st.nextToken();
                    if (!rolesAllowed.contains(currentRole)) continue;
                    rl.add(currentRole);
                }
                Object[] roleArray = rl.toArray();
                Arrays.sort(roleArray);
                this.roles.put(userName, Arrays.asList(roleArray));
            }
            this.passwords.put(userName, password);
        }
        Logger.log(Logger.DEBUG, REALM_RESOURCES, "ArgumentsRealm.Initialised", "" + this.passwords.size());
    }

    public AuthenticationPrincipal authenticateByUsernamePassword(String userName, String password) {
        if (userName == null || password == null) {
            return null;
        }
        String realPassword = (String)this.passwords.get(userName);
        if (realPassword == null) {
            return null;
        }
        if (!realPassword.equals(password)) {
            return null;
        }
        return new AuthenticationPrincipal(userName, password, (List)this.roles.get(userName));
    }

    public AuthenticationPrincipal retrieveUser(String userName) {
        if (userName == null) {
            return null;
        }
        return new AuthenticationPrincipal(userName, (String)this.passwords.get(userName), (List)this.roles.get(userName));
    }
}

