/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.PieChartData;
import fr.ifremer.wao.bean.PieChartSeries;
import fr.ifremer.wao.service.ServiceChart;
import java.util.ArrayList;
import org.nuiton.util.StringUtil;

public class ServiceChartServlet
implements ServiceChart {
    private static final String PROPERTY_SEPARATOR = "&";
    private static final String PROPERTY_VALUE_SEPARATOR = ",";
    private static final String PROPERTY_LABEL_SEPARATOR = "|";
    private static final String PROPERTY_COLOR_SEPARATOR = ",";
    private static final String PROPERTY_TYPE = "cht=";
    private static final String PROPERTY_LABEL = "chl=";
    private static final String PROPERTY_COLOR = "chco=";
    private static final String PROPERTY_SIZE = "chs=";
    private static final String PROPERTY_VALUE = "chd=t:";
    private static final String PROPERTY_BACKGROUND_TRANSPARENT = "chf=bg,s,FFFFFF00";
    private static final int PIE_CHART_MAXI_HEIGHT = 150;
    private static final int PIE_CHART_MAXI_WIDTH = 350;
    private static final String PIE_CHART_MINI_TYPE = "cht=p3";
    private static final String PIE_CHART_MAXI_TYPE = "cht=p3";
    private static final String PIE_CHART_MINI_SIZE = "chs=28x28";
    private static final String PIE_CHART_MAXI_SIZE = "chs=350x150";

    public String getPieChartUrl(PieChartData data, boolean thumb) {
        ArrayList<String> labelsList = new ArrayList<String>();
        ArrayList<Double> valuesList = new ArrayList<Double>();
        ArrayList<String> colorsList = new ArrayList<String>();
        for (PieChartSeries series : data.getSeries()) {
            labelsList.add(series.getLabel());
            valuesList.add(series.getValue());
            colorsList.add(series.getColor());
        }
        String values = StringUtil.join(valuesList, (String)",", (boolean)false);
        String colors = StringUtil.join(colorsList, (String)",", (boolean)false);
        StringBuilder url = new StringBuilder(this.getBaseUrl());
        if (thumb) {
            url.append("cht=p3").append(PROPERTY_SEPARATOR).append(PIE_CHART_MINI_SIZE);
        } else {
            String labels = StringUtil.join(labelsList, (String)PROPERTY_LABEL_SEPARATOR, (boolean)false);
            url.append("cht=p3").append(PROPERTY_SEPARATOR).append(PIE_CHART_MAXI_SIZE).append(PROPERTY_SEPARATOR).append(PROPERTY_LABEL).append(labels);
        }
        url.append(PROPERTY_SEPARATOR).append(PROPERTY_VALUE).append(values).append(PROPERTY_SEPARATOR).append(PROPERTY_COLOR).append(colors).append(PROPERTY_SEPARATOR).append(PROPERTY_BACKGROUND_TRANSPARENT);
        return url.toString();
    }

    public String getHtmlImgTag(PieChartData data, String text, boolean thumb) {
        StringBuilder builder = new StringBuilder("<img src=\"").append(this.getPieChartUrl(data, thumb)).append("\" alt=\"").append(text).append("\" height=\"").append(150).append("\" width=\"").append(350).append("\" />");
        return builder.toString();
    }

    protected String getBaseUrl() {
        String baseUrl = "http://" + WaoProperty.CHART_SERVER_PATH.getValue() + "/chart?";
        return baseUrl;
    }
}

