/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.CompanyImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Administration;
import fr.ifremer.wao.ui.services.WaoManager;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN, UserRole.COORDINATOR}, readOnlyAllowed=false)
@IncludeStylesheet(value={"context:css/administration.css"})
@IncludeJavaScriptLibrary(value={"context:js/AdminUserSelect.js"})
public class Administration {
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser currentUser;
    @Inject
    private Logger logger;
    @Inject
    private WaoManager manager;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceCartography serviceCartography;
    @Inject
    private TypeCoercer typeCoercer;
    @Inject
    private Messages messages;
    @Environmental
    private RenderSupport renderSupport;
    @Property
    private String companyId;
    @Property
    private String userId;
    @Persist
    private List<Company> companies;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<Company> companiesSelectModel;
    private Company company;
    private GenericSelectModel<WaoUser> usersSelectModel;
    @InjectComponent
    private BeanEditForm userForm;
    private boolean addNewCompanySelected;
    private boolean addNewUserSelected;
    private boolean deleteUserSelected;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    private List<WaoUser> users;
    @Property
    private WaoUser user;
    @InjectComponent
    private Zone userFormZone;
    @Inject
    private BeanModelSource beanModelSource;
    @Persist
    private WaoUser userEdited;
    @Persist
    private BeanModel<WaoUser> userModel;
    @Property
    private boolean generatePassword;
    @Property
    private String password;
    @InjectComponent
    private Zone userRoleZone;
    private SelectModel userRoleSelectModel;
    @Persist
    @Property
    private UserRole userRole;
    @Persist
    @Property
    private boolean readOnly;
    @Property
    private UserRole role;
    @Property
    private int roleIndex;
    @Property
    private boolean refreshUserRoleZone;

    void setupRender() throws WaoException {
        this.companies = null;
        this.getCompanies();
        this.userEdited = null;
        this.userModel = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.companyId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.userId = (String)ec.get(String.class, 1);
            }
        } else if (this.currentUser.isCoordinator()) {
            this.companyId = this.currentUser.getCompany().getId();
        }
    }

    Object[] onPassivate() {
        return new String[]{this.companyId, this.userId};
    }

    void afterRender() {
        this.renderSupport.addScript("new AdminUserSelect();");
    }

    public ImportEngine getFishingZoneImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getSamplingPlanImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Log
    public ImportEngine getBoatImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getActivityCalendarImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public InputStream getActivityCalendarLogFile() {
        return this.getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_IMPORT);
    }

    public InputStream getActivityCalendarAccessLogFile() {
        return this.getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_ACCESS);
    }

    private InputStream getActivityCalendarLogFile(WaoProperty property) {
        InputStream result;
        block6: {
            result = null;
            try {
                switch (6.$SwitchMap$fr$ifremer$wao$WaoProperty[property.ordinal()]) {
                    case 1: {
                        result = this.serviceBoat.getActivityCalendarLogAccessFile();
                        break;
                    }
                    case 2: {
                        result = this.serviceBoat.getActivityCalendarLogFile();
                    }
                }
            }
            catch (FileNotFoundException eee) {
                if (!this.logger.isInfoEnabled()) break block6;
                this.logger.info("Not existing log file for " + property);
            }
        }
        return result;
    }

    public boolean isActivityCalendarImportRun() {
        return this.manager.isActivityCalendarImportRun();
    }

    public ImportEngine getBoatDistrictImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Log
    void onImported(ErrorReport report) {
        for (String info : report.getInfos()) {
            this.layout.addInfo(info);
        }
        for (String error : report.getErrors()) {
            this.layout.addError(new String[]{error});
        }
    }

    public List<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            this.companies = this.serviceUser.getCompanies(false);
        }
        return this.companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() throws WaoException {
        if (this.companiesSelectModel == null) {
            this.companiesSelectModel = new GenericSelectModel(this.getCompanies(), Company.class, "name", "id", this.propertyAccess);
        }
        return this.companiesSelectModel;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            this.company = this.companyId != null ? (Company)this.getCompaniesSelectModel().findObject(this.companyId) : new CompanyImpl();
        }
        return this.company;
    }

    public boolean isUsersAvailable() throws WaoException {
        return !StringUtils.isEmpty((String)this.getCompany().getId()) && this.getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        this.addNewCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (this.addNewCompanySelected) {
            this.companyId = null;
        }
        this.userId = null;
        this.userEdited = null;
    }

    void onSuccessFromCompany() throws WaoException {
        this.serviceUser.createUpdateCompany(this.company);
        this.companyId = this.company.getId();
    }

    @Log
    public List<WaoUser> getUsers() {
        if (this.users == null) {
            this.users = this.serviceUser.getUsersByCompany(this.getCompany());
        }
        return this.users;
    }

    private WaoUser findUser(String id) {
        for (WaoUser user : this.getUsers()) {
            if (!user.getId().equals(id)) continue;
            return user;
        }
        return null;
    }

    public String getUserOptionStyle() {
        String result = "";
        if (!this.user.getActive()) {
            result = "line-through";
        }
        return result;
    }

    @Log
    void onSelectedFromAddNewUser() {
        this.addNewUserSelected = true;
    }

    @Log
    void onSelectedFromDeleteUser() {
        this.deleteUserSelected = true;
    }

    @Log
    void onSuccessFromUserActionsForm() throws WaoException {
        if (this.addNewUserSelected) {
            this.userId = null;
        } else if (this.deleteUserSelected && this.userId != null) {
            this.userEdited = this.findUser(this.userId);
            try {
                this.serviceUser.deleteUser(this.userEdited);
                this.userEdited = null;
                this.userId = null;
                this.layout.addInfo("Utilisateur supprim\u00e9 avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("'User id : " + this.userId);
        }
    }

    public WaoUser getUserEdited() throws WaoException {
        if (this.userEdited == null) {
            if (this.userId != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("User exist in selectModel : " + this.userId);
                }
                this.userEdited = this.findUser(this.userId);
            } else {
                this.userEdited = this.serviceUser.getNewUser(this.getCompany());
                this.generatePassword = true;
            }
        }
        return this.userEdited;
    }

    public BeanModel<WaoUser> getUserModel() {
        if (this.userModel == null) {
            this.userModel = this.beanModelSource.createEditModel(WaoUser.class, this.messages);
            this.userModel.add("userRole", null);
            this.userModel.include(new String[]{"firstName", "lastName", "login", "password", "phoneNumber", "userRole", "active"});
        }
        return this.userModel;
    }

    @Log
    void onSelectedFromUserForm() {
        this.refreshUserRoleZone = false;
    }

    @Log
    void onValidateFormFromUserForm() {
        this.userForm.clearErrors();
        if (this.userEdited.getUserRoles().isEmpty()) {
            this.userForm.recordError("L'utilisateur doit au minimum avoir un r\u00f4le.");
        }
    }

    @Log
    Object onSuccessFromUserForm() throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("User : " + this.userEdited);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            this.userEdited.setPassword(this.password);
            this.userEdited.setPasswordChanged(true);
        }
        try {
            this.serviceUser.createUpdateUser(this.userEdited, this.generatePassword);
            this.userId = this.userEdited.getId();
        }
        catch (WaoBusinessException eee) {
            if (eee.getType().equals((Object)WaoBusinessException.Type.SMTP_NOT_FOUND)) {
                this.layout.addInfo(eee.getMessage());
                this.userId = this.userEdited.getId();
            }
            this.layout.addError(new String[]{eee.getMessage()});
        }
        return this;
    }

    @Log
    Object onFailureFromUserForm() {
        return this.userForm;
    }

    public SelectModel getUserRoleSelectModel() {
        if (this.userRoleSelectModel == null) {
            ArrayList<OptionModel> options = new ArrayList<OptionModel>();
            options.add(this.newUserRoleOption(UserRole.OBSERVER));
            options.add(this.newUserRoleOption(UserRole.COORDINATOR));
            if (this.currentUser.isAdmin()) {
                options.add(this.newUserRoleOption(UserRole.ADMIN));
                options.add(this.newUserRoleOption(UserRole.GUEST));
            }
            this.userRoleSelectModel = new SelectModelImpl(null, options);
        }
        return this.userRoleSelectModel;
    }

    private OptionModel newUserRoleOption(UserRole role) {
        return new OptionModelImpl(role.getLabel(), (Object)role);
    }

    public String getRoleReadOnly() {
        String text = "";
        if (this.userEdited.isReadOnly(this.role)) {
            text = "lecture seule";
        }
        return text;
    }

    @Log
    void onChangeFromUserRole(String value) {
        this.userRole = StringUtils.isNotEmpty((String)value) ? UserRole.valueOf((String)value) : null;
    }

    @Log
    void onChangeFromReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Log
    Object onActionFromAddRole() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Add userRole : " + this.userRole + " (readOnly=" + this.readOnly + ")");
        }
        if (this.userRole != null) {
            this.userEdited.addUserRole(this.userRole, this.readOnly);
        }
        this.userRole = null;
        this.readOnly = false;
        this.refreshUserRoleZone = true;
        return this.userRoleZone;
    }

    @Log
    Object onActionFromRemoveRole(int roleIndex) {
        UserRole roleToRemove = (UserRole)this.userEdited.getUserRoles().get(roleIndex);
        this.userEdited.removeUserRole(roleToRemove);
        this.refreshUserRoleZone = true;
        return this.userRoleZone;
    }

    static /* synthetic */ ServiceReferential access$000(Administration x0) {
        return x0.serviceReferential;
    }

    static /* synthetic */ ServiceSampling access$100(Administration x0) {
        return x0.serviceSampling;
    }

    static /* synthetic */ ServiceBoat access$200(Administration x0) {
        return x0.serviceBoat;
    }

    static /* synthetic */ ServiceCartography access$300(Administration x0) {
        return x0.serviceCartography;
    }
}

