package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.services.service.administration.LoginMustBeUniqueException;
import fr.ifremer.wao.services.service.administration.UnknownBoatRegistrationCodesException;
import fr.ifremer.wao.services.service.administration.UpdateWaoUserCommand;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.nuiton.util.StringUtil;

@Results({
        @Result(name= ActionSupport.SUCCESS, type="redirectAction", params = { "actionName", "wao-users", "organisationId", "%{organisationId}" }),
        @Result(name= ActionSupport.NONE, type="redirectAction", params = { "actionName", "news" })
})
public class EditWaoUserAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient WaoUsersService service;

    protected Optional<String> optionalWaoUserId = Optional.absent();

    protected Optional<String> optionalOrganisationId = Optional.absent();

    protected UpdateWaoUserCommand updateWaoUserCommand;

    protected String companyId;

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setWaoUserId(String waoUserId) {
        this.optionalWaoUserId = Optional.fromNullable(Strings.emptyToNull(waoUserId));
    }

    public void setOrganisationId(String organisationId) {
        this.optionalOrganisationId = Optional.fromNullable(Strings.emptyToNull(organisationId));
    }

    @Override
    public void prepare() {

        updateWaoUserCommand = service.newUpdateWaoUserCommand(getObsProgram(), optionalWaoUserId, optionalOrganisationId);

        if (updateWaoUserCommand.getWaoUser().getOrganisation() != null) {
            setOrganisationId(updateWaoUserCommand.getWaoUser().getOrganisation().getCompany().getTopiaId());
        }

    }

    @Override
    public void validate() {

        try {
            service.preValidate(updateWaoUserCommand);
        } catch (UnknownBoatRegistrationCodesException unknownBoatRegistrationCodes) {
            addFieldError("updateWaoUserCommand.canReadBoats", t("wao.ui.unknownBoatRegistrationCodes", Joiner.on(", ").join(unknownBoatRegistrationCodes.getRegistrationCodes())));
        } catch (LoginMustBeUniqueException e) {
            addFieldError("updateWaoUserCommand.waoUser.login", t("wao.ui.form.updateWaoUserCommand.error.loginMustBeUnique"));
        }

        if (updateWaoUserCommand.getPasswordStrategy().isDefinePassword()) {
            if (StringUtils.isEmpty(updateWaoUserCommand.getClearPassword())) {
                addFieldError("updateWaoUserCommand.clearPassword", t("wao.ui.form.updateWaoUserCommand.missingPassword"));
            }
            if ( ! updateWaoUserCommand.getClearPassword().equals(updateWaoUserCommand.getClearPasswordConfirmation())) {
                addFieldError("updateWaoUserCommand.clearPasswordConfirmation", t("wao.ui.form.updateWaoUserCommand.passwordMismatch"));
            }
        }

        if ( ! StringUtil.isEmail(updateWaoUserCommand.getWaoUser().getLogin())) {
            addFieldError("updateWaoUserCommand.waoUser.login", t("wao.ui.form.updateWaoUserCommand.loginMustBeEmail"));
        }

        if (updateWaoUserCommand.getOrganisationId() == null) {
            addFieldError("updateWaoUserCommand.companyId", t("wao.ui.form.updateWaoUserCommand.requiredCompany"));
        }

        if ( ! updateWaoUserCommand.getWaoUser().isActive() && updateWaoUserCommand.getPasswordStrategy().isGeneratePassword()) {
            addFieldError("updateWaoUserCommand.passwordStrategy", t("wao.ui.form.updateWaoUserCommand.illegalPasswordStrategyForInactiveUser"));
        }

    }

    @Override
    public String execute() {

        service.save(updateWaoUserCommand);

        session.addMessage(t("wao.ui.form.updateWaoUserCommand.success", updateWaoUserCommand.getWaoUser().getLogin()));

        // for redirection
        setOrganisationId(updateWaoUserCommand.getWaoUser().getOrganisation().getCompany().getTopiaId());

        String result;
        if (getAuthenticatedWaoUser().isAuthorizedToViewCompanyUsers()) {
            result = SUCCESS;
        } else {
            result = NONE;
        }

        return result;

    }

    public String getWaoUserId() {
        return optionalWaoUserId.orNull();
    }

    public String getOrganisationId() {
        return optionalOrganisationId.orNull();
    }

    public UpdateWaoUserCommand getUpdateWaoUserCommand() {
        if (updateWaoUserCommand == null) {
            prepare();
        }
        return updateWaoUserCommand;
    }

}
