package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableSortedSet;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.Laboratory;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.services.service.administration.LaboratoriesService;
import fr.ifremer.wao.services.service.administration.OrganisationNameMustBeUniqueException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import java.util.LinkedHashMap;
import java.util.Set;

@Results({
        @Result(name="success", type="redirectAction", params = { "actionName", "laboratories" })
})
public class EditLaboratoryAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient LaboratoriesService service;

    protected String laboratoryId;

    protected Laboratory laboratory;

    protected LinkedHashMap<String, String> possibleMembersForLaboratory;

    protected Set<String> laboratoryMemberIds;

    public void setLaboratoryId(String laboratoryId) {
        this.laboratoryId = laboratoryId;
    }

    public void setLaboratory(Laboratory laboratory) {
        this.laboratory = laboratory;
    }

    public void setService(LaboratoriesService service) {
        this.service = service;
    }

    @Override
    public void prepare() {
        if (StringUtils.isEmpty(laboratoryId)) {
            laboratory = service.newLaboratory();
        } else {
            laboratory = service.getLaboratory(laboratoryId);
        }
        ImmutableSortedSet<WaoUser> possibleMembersForLaboratory =
                service.getPossibleMembersForLaboratory(laboratory);
        this.possibleMembersForLaboratory = new LinkedHashMap<>();
        for (WaoUser possibleMemberForLaboratory : possibleMembersForLaboratory) {
            this.possibleMembersForLaboratory.put(possibleMemberForLaboratory.getTopiaId(), possibleMemberForLaboratory.getFullName());
        }
        laboratoryMemberIds = laboratory.getWaoUserTopiaIds();
    }

    public Set<String> getLaboratoryMemberIds() {
        return laboratoryMemberIds;
    }

    public void setLaboratoryMemberIds(Set<String> laboratoryMemberIds) {
        this.laboratoryMemberIds = laboratoryMemberIds;
    }

    public LinkedHashMap<String, String> getPossibleMembersForLaboratory() {
        return possibleMembersForLaboratory;
    }

    @Override
    public void validate() {

        try {
            service.preValidate(laboratory, laboratoryMemberIds);
        } catch (OrganisationNameMustBeUniqueException e) {
            addFieldError("company.name", t("wao.ui.form.Organisation.error.nameMustBeUnique"));
        }

    }

    @Override
    public String execute() {

        service.save(laboratory);

        session.addMessage(t("wao.ui.action.save.success"));

        return SUCCESS;

    }

    public String getLaboratoryId() {
        return laboratoryId;
    }

    public Laboratory getLaboratory() {
        return laboratory;
    }

}
