package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.services.service.ContactsFilterValues;
import fr.ifremer.wao.services.service.SynthesisService;
import fr.ifremer.wao.web.WaoJsonActionSupport;
import org.apache.commons.lang3.StringUtils;

/**
 * Action pour récupérer les valeurs dans les filtres de l'écran synthèse.
 *
 * @since 5.1
 */
public class SynthesisFilterValuesJsonAction extends WaoJsonActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient SynthesisService service;

    protected ContactsFilter filter;

    protected ContactsFilterValues filterValues;

    protected String filterValuesField;

    public void setService(SynthesisService service) {
        this.service = service;
    }

    public void setFilterValuesField(String filterValuesField) {
        this.filterValuesField = filterValuesField;
    }

    public ContactsFilter getFilter() {
        if (filter == null) {
            prepare();
        }
        return filter;
    }

    @Override
    public void prepare() {

        filter = service.newFilter(session.getAuthenticatedWaoUser());

    }

    @Override
    public String execute() {

        filterValues = service.getSynthesis(session.getAuthenticatedWaoUser(), filter).getContactsFilterValues();

        if (StringUtils.isNotBlank(filterValuesField)) {

            // le client ne demande qu'un seul champ, on peut éviter de retourner l'objet complet

            filterValues = filterValues.getCopyWithSingleProperty(filterValuesField);

        }

        return SUCCESS;

    }

    public ContactsFilterValues getFilterValues() {
        return filterValues;
    }

}