package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.services.service.Synthesis;
import fr.ifremer.wao.services.service.SynthesisService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.nuiton.i18n.I18n;

public class SynthesisAction extends WaoJspActionSupport implements Preparable {

    protected ContactsFilter filter;

    protected SynthesisService service;

    protected Synthesis synthesis;

    public void setService(SynthesisService service) {
        this.service = service;
    }

    public ContactsFilter getFilter() {
        if (filter == null) {
            prepare();
        }
        return filter;
    }

    @Override
    public void prepare() {

        if (filter == null) {
            filter = service.newFilter(getAuthenticatedWaoUser());
        }

    }

    @Override
    public void validate() {

        if (filter.getPeriodFrom() != null && filter.getPeriodTo() != null && filter.getPeriodTo().before(filter.getPeriodFrom())) {
            addFieldError("filter.periodTo", I18n.l(getLocale(), "wao.ui.periodToMustBeAfterPeriodFrom"));
        }

    }

    @Override
    public String execute() {

        filter = MoreObjects.firstNonNull(session.getSynthesisFilter(), filter);

        return applyFilter();

    }

    public String resetFilter() {

        filter = service.newFilter(getAuthenticatedWaoUser());

        return applyFilter();

    }

    public String applyFilter() {

        getSession().setSynthesisFilter(filter);

        synthesis = service.getSynthesis(getSession().getAuthenticatedWaoUser(), filter);

        return SUCCESS;
    }

    public Synthesis getSynthesis() {
        return synthesis;
    }
}
