package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.SampleRowsFilter;
import fr.ifremer.wao.entity.ObsProgram;
import fr.ifremer.wao.services.AuthenticatedWaoUser;
import fr.ifremer.wao.services.service.ObsMerSamplingPlanService;
import fr.ifremer.wao.services.service.ObsVenteSamplingPlanService;
import fr.ifremer.wao.services.service.SampleRowsFilterValues;
import fr.ifremer.wao.services.service.SamplingPlan;
import fr.ifremer.wao.services.service.SclerochronologySamplingPlanService;
import fr.ifremer.wao.web.WaoJsonActionSupport;
import org.apache.commons.lang3.StringUtils;

public class SampleRowsFilterValuesJsonAction extends WaoJsonActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected ObsMerSamplingPlanService obsMerSamplingPlanService;

    protected ObsVenteSamplingPlanService obsVenteSamplingPlanService;

    protected SclerochronologySamplingPlanService sclerochronologySamplingPlanService;

    protected SampleRowsFilter filter;

    protected SampleRowsFilterValues filterValues;

    protected String filterValuesField;

    public void setObsMerSamplingPlanService(ObsMerSamplingPlanService obsMerSamplingPlanService) {
        this.obsMerSamplingPlanService = obsMerSamplingPlanService;
    }

    public void setObsVenteSamplingPlanService(ObsVenteSamplingPlanService obsVenteSamplingPlanService) {
        this.obsVenteSamplingPlanService = obsVenteSamplingPlanService;
    }

    public void setSclerochronologySamplingPlanService(SclerochronologySamplingPlanService sclerochronologySamplingPlanService) {
        this.sclerochronologySamplingPlanService = sclerochronologySamplingPlanService;
    }

    public SampleRowsFilter getFilter() {
        if (filter == null) {
            prepare();
        }
        return filter;
    }

    public void setFilterValuesField(String filterValuesField) {
        this.filterValuesField = filterValuesField;
    }

    @Override
    public void prepare() {

        AuthenticatedWaoUser authenticatedWaoUser = session.getAuthenticatedWaoUser();
        ObsProgram obsProgram = authenticatedWaoUser.getObsProgram();

        if (obsProgram.isObsMer()) {
            filter = obsMerSamplingPlanService.newSampleRowsFilter(authenticatedWaoUser);
        } else if (obsProgram.isObsVente()) {
            filter = obsVenteSamplingPlanService.newSampleRowsFilter(authenticatedWaoUser);
        } else  if (obsProgram.isSclerochronology()) {
            filter = sclerochronologySamplingPlanService.newSampleRowsFilter(authenticatedWaoUser);
        } else {
            throw new UnsupportedOperationException();
        }

    }

    @Override
    public String execute() {

        SamplingPlan samplingPlan;
        ObsProgram obsProgram = filter.getObsProgram();
        if (obsProgram.isObsMer()) {
            samplingPlan = obsMerSamplingPlanService.getSamplingPlan(session.getAuthenticatedWaoUser(), filter);
        } else if (obsProgram.isObsVente()) {
            samplingPlan = obsVenteSamplingPlanService.getSamplingPlan(session.getAuthenticatedWaoUser(), filter);
        } else  if (obsProgram.isSclerochronology()) {
            samplingPlan = sclerochronologySamplingPlanService.getSamplingPlan(session.getAuthenticatedWaoUser(), filter);
        } else {
            throw new UnsupportedOperationException();
        }

        filterValues = samplingPlan.getFilterValues();

        if (StringUtils.isNotBlank(filterValuesField)) {

            // le client ne demande qu'un seul champ, on peut éviter de retourner l'objet complet

            filterValues = filterValues.getCopyWithSingleProperty(filterValuesField);

        }

        return SUCCESS;
    }

    public String getFilterValuesField() {
        return filterValuesField;
    }

    public SampleRowsFilterValues getFilterValues() {
        return filterValues;
    }

}
