package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.SampleRowsFilter;
import fr.ifremer.wao.services.service.SampleRowsFilterValues;
import fr.ifremer.wao.services.service.SamplingPlan;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.i18n.I18n;

import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractSamplingPlanAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient SamplingPlanService samplingPlanService;

    public void setSamplingPlanService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    protected SampleRowsFilter filter;

    protected SamplingPlan samplingPlan;

    public SampleRowsFilter getFilter() {
        if (filter == null) {
            prepare();
        }
        return filter;
    }

    @Override
    public void prepare() {

        if (filter == null) {
            filter = samplingPlanService.newSampleRowsFilter(getAuthenticatedWaoUser());
        }

    }

    @Override
    public void validate() {

        if (filter.getPeriodFrom() != null && filter.getPeriodTo() != null && filter.getPeriodTo().before(filter.getPeriodFrom())) {
            addFieldError("filter.periodTo", I18n.l(getLocale(), "wao.ui.periodToMustBeAfterPeriodFrom"));
        }

    }

    @Override
    public String execute() {

        filter = MoreObjects.firstNonNull(session.getSampleRowsFilter(), filter);

        return applyFilter();

    }

    public String resetFilter() {

        filter = samplingPlanService.newSampleRowsFilter(getAuthenticatedWaoUser());

        return applyFilter();

    }

    public String applyFilter() {

        getSession().setSampleRowsFilter(filter);

        samplingPlan = samplingPlan();

        return SUCCESS;

    }

    protected abstract SamplingPlan samplingPlan();

    public SamplingPlan getSamplingPlan() {
        return samplingPlan;
    }

    public String getSampleRowToHighlightId() {
        return getSession().getSampleRowToHighlightId();
    }

    public SampleRowsFilterValues getFilterValues() {
        SampleRowsFilterValues filterValues = getSamplingPlan().getFilterValues();
        return filterValues;
    }

    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");

    public boolean isCurrentMonth(Date month) {

        String currentStr = dateFormat.format(getNow());
        String monthStr = dateFormat.format(month);
        return currentStr.equals(monthStr);
    }

    public String getFilterPeriodFromPlaceholder() {
        String placeholder = formatMonth(DateUtils.addMonths(getNow(), 1));
        return placeholder;
    }

    public String getFilterPeriodToPlaceholder() {
        String placeholder = formatMonth(DateUtils.addYears(getNow(), 1));
        return placeholder;
    }
}
