package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.wao.WaoUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.nuiton.web.struts2.I18nTextProvider;

public class WaoI18nTextProvider extends I18nTextProvider {

    @Override
    protected String getSafeText(String key, String value) {
        String text = super.getSafeText(key, value);
        ActionMapping actionMapping = (ActionMapping) ActionContext.getContext().get(ServletActionContext.ACTION_MAPPING);
        if (actionMapping.getNamespace().contains("sclerochronology")) {
            if (WaoUtils.isFrench(localeProvider.getLocale())) {
                text = text.replaceAll("Contacts", "Prélèvements");
                text = text.replaceAll("contacts", "prélèvements");
                text = text.replaceAll("Contact", "Prélèvement");
                text = text.replaceAll("contact", "prélèvement");
            } else {
                text = text.replaceAll("Contacts", "Samples");
                text = text.replaceAll("contacts", "samples");
                text = text.replaceAll("Contact", "Sample");
                text = text.replaceAll("contact", "sample");
            }
        }
        return text;
    }
}
