package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Redirige toutes les requêtes entrantes vers la racine du context-path (/wao)
 *
 * @since 4.2
 */
public class RedirectToContextPathRootFilter implements Filter {

    private static final Log log = LogFactory.getLog(RedirectToContextPathRootFilter.class);

    @Override
    public void init(FilterConfig filterConfig) {
        // nothing to do
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {

        String contextPath = ((HttpServletRequest) servletRequest).getContextPath();

        if (log.isTraceEnabled()) {
            log.trace("will redirect to " + contextPath);
        }

        ((HttpServletResponse) servletResponse).sendRedirect(contextPath);

    }

    @Override
    public void destroy() {
        // nothing to do
    }

}
