/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import fr.ifremer.wao.WaoTechnicalException;
import fr.ifremer.wao.services.WaoWebApplicationContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWaoWebApplicationContext
implements WaoWebApplicationContext {
    private static final Log log = LogFactory.getLog(DefaultWaoWebApplicationContext.class);
    protected String instanceUrl;

    public DefaultWaoWebApplicationContext(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected String formatUrl(String actionUrl) {
        Map emptyMap = Collections.emptyMap();
        return this.formatUrl(actionUrl, emptyMap);
    }

    protected String formatUrl(String actionUrl, Map<String, String> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.instanceUrl).append("/").append(actionUrl);
        if (!parameters.isEmpty()) {
            TreeSet queryStringElements = Sets.newTreeSet();
            try {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    String queryStringElement = parameter.getKey() + '=' + URLEncoder.encode(parameter.getValue(), Charsets.UTF_8.name());
                    queryStringElements.add(queryStringElement);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"should never occur", (Throwable)e);
                }
                throw new WaoTechnicalException((Throwable)e);
            }
            stringBuilder.append('?').append(Joiner.on((char)'&').join((Iterable)queryStringElements));
        }
        return stringBuilder.toString();
    }
}

