/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web;

import com.google.common.base.StandardSystemProperty;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import fr.ifremer.wao.WaoApplicationConfig;
import fr.ifremer.wao.WaoTechnicalException;
import fr.ifremer.wao.WaoTopiaApplicationContext;
import fr.ifremer.wao.WaoTopiaPersistenceContext;
import fr.ifremer.wao.services.DefaultWaoServiceContext;
import fr.ifremer.wao.services.WaoApplicationContext;
import fr.ifremer.wao.services.WaoServiceContext;
import fr.ifremer.wao.services.WaoWebApplicationContext;
import fr.ifremer.wao.services.service.BoatsFilterValues;
import fr.ifremer.wao.services.service.BoatsFilterValuesCacheKey;
import fr.ifremer.wao.services.service.BoatsFilterValuesCacheLoader;
import fr.ifremer.wao.services.service.ContactsFilterValues;
import fr.ifremer.wao.services.service.ContactsFilterValuesCacheKey;
import fr.ifremer.wao.services.service.ContactsFilterValuesCacheLoader;
import fr.ifremer.wao.services.service.InitWaoService;
import fr.ifremer.wao.services.service.SamplingPlan;
import fr.ifremer.wao.services.service.SamplingPlanCacheKey;
import fr.ifremer.wao.services.service.Synthesis;
import fr.ifremer.wao.services.service.SynthesisCacheKey;
import fr.ifremer.wao.web.CacheInvalidationTopiaListener;
import fr.ifremer.wao.web.DefaultWaoWebApplicationContext;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;

public class DefaultWaoApplicationContext
implements WaoApplicationContext {
    private static Log log = LogFactory.getLog(DefaultWaoApplicationContext.class);
    public static final String APPLICATION_CONTEXT_PARAMETER = "WaoApplicationContext";
    protected WaoTopiaApplicationContext topiaApplicationContext;
    protected WaoApplicationConfig applicationConfig;
    protected WaoWebApplicationContext webApplicationContext;
    protected Random random;
    protected Cache<SamplingPlanCacheKey, SamplingPlan> samplingPlansCache;
    protected Cache<BoatsFilterValuesCacheKey, BoatsFilterValues> boatsFilterValuesCache;
    protected Cache<SynthesisCacheKey, Synthesis> synthesesCache;
    protected Cache<ContactsFilterValuesCacheKey, ContactsFilterValues> contactsFilterValuesCache;

    public WaoApplicationConfig getApplicationConfig() {
        if (this.applicationConfig == null) {
            this.applicationConfig = new WaoApplicationConfig();
        }
        return this.applicationConfig;
    }

    public WaoTopiaApplicationContext getTopiaApplicationContext() {
        if (this.topiaApplicationContext == null) {
            this.topiaApplicationContext = new WaoTopiaApplicationContext(this.getApplicationConfig().getTopiaProperties());
        }
        return this.topiaApplicationContext;
    }

    public String newUuid() {
        return UUID.randomUUID().toString();
    }

    public WaoWebApplicationContext getWebApplicationContext() {
        if (this.webApplicationContext == null) {
            this.webApplicationContext = new DefaultWaoWebApplicationContext(this.getApplicationConfig().getInstanceUrl());
        }
        return this.webApplicationContext;
    }

    public Date getNow() {
        Date now = new Date();
        return now;
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    public Cache<SamplingPlanCacheKey, SamplingPlan> getSamplingPlansCache() {
        if (this.samplingPlansCache == null) {
            this.samplingPlansCache = this.newCacheBuilder(100).expireAfterAccess(30L, TimeUnit.DAYS).build();
        }
        return this.samplingPlansCache;
    }

    public Cache<BoatsFilterValuesCacheKey, BoatsFilterValues> getBoatsFilterValuesCache() {
        if (this.boatsFilterValuesCache == null) {
            BoatsFilterValuesCacheLoader loader = new BoatsFilterValuesCacheLoader((WaoApplicationContext)this);
            this.boatsFilterValuesCache = this.newCacheBuilder(100).expireAfterAccess(20L, TimeUnit.DAYS).refreshAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)loader);
        }
        return this.boatsFilterValuesCache;
    }

    public Cache<SynthesisCacheKey, Synthesis> getSynthesesCache() {
        if (this.synthesesCache == null) {
            this.synthesesCache = this.newCacheBuilder(100).expireAfterAccess(30L, TimeUnit.DAYS).build();
        }
        return this.synthesesCache;
    }

    public Cache<ContactsFilterValuesCacheKey, ContactsFilterValues> getContactsFilterValuesCache() {
        if (this.contactsFilterValuesCache == null) {
            ContactsFilterValuesCacheLoader loader = new ContactsFilterValuesCacheLoader((WaoApplicationContext)this);
            this.contactsFilterValuesCache = this.newCacheBuilder(100).expireAfterAccess(20L, TimeUnit.DAYS).refreshAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)loader);
        }
        return this.contactsFilterValuesCache;
    }

    protected <K, V> CacheBuilder<K, V> newCacheBuilder(int expectedMaximumCacheSize) {
        int maximumCacheSize = this.applicationConfig.isCachingEnabled() ? expectedMaximumCacheSize : 0;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)maximumCacheSize);
        if (log.isInfoEnabled()) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder;
    }

    public WaoTopiaPersistenceContext newPersistenceContext() {
        WaoTopiaPersistenceContext persistenceContext = this.getTopiaApplicationContext().newPersistenceContext();
        if (this.applicationConfig.isCachingEnabled()) {
            CacheInvalidationTopiaListener cacheInvalidationTopiaListener = new CacheInvalidationTopiaListener(this.getSamplingPlansCache(), this.getBoatsFilterValuesCache(), this.getSynthesesCache());
            persistenceContext.addTopiaEntityListener((TopiaEntityListener)cacheInvalidationTopiaListener);
            persistenceContext.addTopiaTransactionListener((TopiaTransactionListener)cacheInvalidationTopiaListener);
        }
        this.logCacheStats();
        return persistenceContext;
    }

    public WaoServiceContext newServiceContext(WaoTopiaPersistenceContext persistenceContext, Locale locale) {
        DefaultWaoServiceContext newServiceContext = new DefaultWaoServiceContext((WaoApplicationContext)this, persistenceContext, locale);
        return newServiceContext;
    }

    public void close() {
        this.logCacheStats();
        if (this.topiaApplicationContext != null) {
            this.topiaApplicationContext.close();
        }
    }

    protected void logCacheStats() {
        if (log.isInfoEnabled()) {
            log.info((Object)("samplingPlansCache stats: " + this.getSamplingPlansCache().stats().toString()));
            log.info((Object)("boatsFilterValuesCache stats: " + this.getBoatsFilterValuesCache().stats().toString()));
            log.info((Object)("contactsFilterValuesCache stats: " + this.getContactsFilterValuesCache().stats().toString()));
            log.info((Object)("synthesesCache stats: " + this.getSynthesesCache().stats().toString()));
        }
    }

    public void init() {
        if (this.getApplicationConfig().isLogConfigurationProvided()) {
            File log4jConfigurationFile = this.getApplicationConfig().getLogConfigurationFile();
            String log4jConfigurationFileAbsolutePath = log4jConfigurationFile.getAbsolutePath();
            if (log4jConfigurationFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("will use logging configuration " + log4jConfigurationFileAbsolutePath));
                }
                LogManager.resetConfiguration();
                PropertyConfigurator.configure((String)log4jConfigurationFileAbsolutePath);
                log = LogFactory.getLog(DefaultWaoApplicationContext.class);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("there is no file " + log4jConfigurationFileAbsolutePath + ". Default logging configuration will be used."));
            }
        } else {
            log.info((Object)"will use default logging configuration");
        }
        DefaultI18nInitializer initializer = new DefaultI18nInitializer("wao");
        initializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)initializer, (Locale)Locale.FRANCE);
        LocalizedTextUtil.addDefaultResourceBundle((String)"i18n.wao-web");
        this.checkTempDir();
        WaoTopiaPersistenceContext persistenceContext = this.newPersistenceContext();
        WaoServiceContext serviceContext = this.newServiceContext(persistenceContext, Locale.FRANCE);
        InitWaoService initWaoService = (InitWaoService)serviceContext.newService(InitWaoService.class);
        initWaoService.init();
        persistenceContext.close();
    }

    protected void checkTempDir() {
        String javaIoTempDirValue = StandardSystemProperty.JAVA_IO_TMPDIR.value();
        if (StringUtils.isBlank((CharSequence)javaIoTempDirValue)) {
            throw new WaoTechnicalException(StandardSystemProperty.JAVA_IO_TMPDIR.key() + " is blank");
        }
        File javaIoTempDirFile = new File(javaIoTempDirValue);
        if (javaIoTempDirFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("storage directory exists " + javaIoTempDirFile.getAbsolutePath()));
            }
        } else {
            boolean created;
            if (log.isInfoEnabled()) {
                log.info((Object)("storage directory does not exist, creating " + javaIoTempDirFile.getAbsolutePath()));
            }
            if (!(created = javaIoTempDirFile.mkdirs())) {
                throw new WaoTechnicalException("unable to create directory " + javaIoTempDirFile.getAbsolutePath());
            }
        }
        if (!javaIoTempDirFile.isDirectory()) {
            throw new WaoTechnicalException("file exists but is not a directory " + javaIoTempDirFile.getAbsolutePath());
        }
        if (!javaIoTempDirFile.canWrite()) {
            throw new WaoTechnicalException("directory exists but is not writable " + javaIoTempDirFile.getAbsolutePath());
        }
    }
}

