<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

    <head>
        <title>
            <s:text name="wao.ui.page.SamplingPlan.title" />
        </title>

        <script>

            $(document).ready(function () {

                // gestion des filtres

                var sampleRowsFilterMappings = [
                    <s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
                        {
                            filterName: 'companyIds',
                            filterLabel: "<s:text name="wao.ui.entity.Company"/>",
                            filterValuesField: 'companies',
                        },
                    </s:if>
                    {
                        filterName: 'programNames',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.programName"/>",
                        filterValuesField: 'programNames',
                    },
                    {
                        filterName: 'sampleRowCodes',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.code"/>",
                        filterValuesField: 'sampleRowCodes',
                    },
                    {
                        filterName: 'fishingZoneFacadeNames',
                        filterLabel: "<s:text name="wao.ui.field.FishingZone.facadeName"/>",
                        filterValuesField: 'fishingZoneFacadeNames',
                    },
                    {
                        filterName: 'fishingZoneSectorNames',
                        filterLabel: "<s:text name="wao.ui.field.FishingZone.sectorName"/>",
                        filterValuesField: 'fishingZoneSectorNames',
                    },
                    {
                        filterName: 'fishingGearDcfIds',
                        filterLabel: "<s:text name="wao.ui.entity.fishingGearDcf"/>",
                        filterValuesField: 'fishingGearDcfs',
                    },
                    {
                        filterName: 'targetSpeciesDcfIds',
                        filterLabel: "<s:text name="wao.ui.entity.targetSpeciesDcf"/>",
                        filterValuesField: 'targetSpeciesDcfs',
                    }
                ];

                filter = <s:property value="filter" escapeHtml="false"/>;

                sampleRowsFilterController2 = new FilterController2(sampleRowsFilterMappings, filter, WAO.SAMPLE_ROWS_FILTER_VALUES_JSON_URL, $('#sampling-plan-filters-form fieldset.extra-filters'));
                sampleRowsFilterController2.init();

                // gestion du mode estimé vs réel

                $('#switch-estimated-real').click(function () {
                    $('#switch-estimated-real, table.sampling-plan').toggleClass('show-estimated').toggleClass('show-real');

                    // FIXME brendan 21/10/14 désactivé car ça casse la page : on se retrouve avec des cellules en jours et en marées parce que ça passe la td en style="display: table-cell" ce qui montre la cellule qui devrait être cachée
                    // $('.estimated-differ-from-real').effect( "highlight", "slow" )
                });

                // gestion du mode compact vs vue complète

                var $views = $('#switch-compact-full-view, table.sampling-plan');
                $views.toggleCompactFullView(WAO.getCookie().samplingPlanFullView);

                $('#switch-compact-full-view').click(function () {
                    WAO.getCookie().samplingPlanFullView = ! WAO.getCookie().samplingPlanFullView;
                    $views.toggleCompactFullView(WAO.getCookie().samplingPlanFullView);
                });    

                // gestion du mode observations vs jours de mer

                $.fn.toggleObservationsDaysView = function (daysView) {
                    return this.each(function () {
                        if (daysView) {
                            $(this).addClass('days-view').removeClass('observations-view');
                        } else {
                            $(this).addClass('observations-view').removeClass('days-view');
                        }
                    })
                }

                var $views2 = $('#switch-observations-days-view, table.sampling-plan');
                $views2.toggleObservationsDaysView(WAO.getCookie().samplingPlanDaysView);

                $('#switch-observations-days-view').click(function () {
                    WAO.getCookie().samplingPlanDaysView = ! WAO.getCookie().samplingPlanDaysView;
                    $views2.toggleObservationsDaysView(WAO.getCookie().samplingPlanDaysView);
                });

            });

        </script>

    </head>

    <content tag="mainClass">large</content>
    <content tag="samplingPlanMenuItemClass">active</content>
    
    <s:if test="authenticatedWaoUser.authorizedToEditSamplingPlan">
        <content tag="administrationMenuOtherOptions">
            <li>
                <s:url action="edit-sample-row!input" id="createSampleRow"/>
                <s:a href="%{createSampleRow}">
                    <i class="icon-plus"></i> <s:text name="wao.ui.action.createSampleRow"/>
                </s:a>
            </li>
        </content>
    </s:if>
    
    <s:form method="GET" id="sampling-plan-filters-form" cssClass="filters-form">

        <fieldset class="filters-group">

            <s:textfield name="filter.periodFrom"
                         label="%{getText('wao.ui.form.periodFrom')}"
                         placeholder="%{getFilterPeriodFromPlaceholder()}"
                         cssClass="input-small" />

            <s:textfield name="filter.periodTo"
                         label="%{getText('wao.ui.form.period.to')}"
                         placeholder="%{getFilterPeriodToPlaceholder()}"
                         cssClass="input-small" />

        </fieldset>

        <fieldset class="extra-filters">

        </fieldset>

        <div class="form-actions">

            <s:submit type="button" action="sampling-plan!applyFilter" cssClass="btn btn-primary">
                <i class="icon-filter"></i> <s:text name="wao.ui.action.filter" />
            </s:submit>

            <s:submit type="button" action="sampling-plan!resetFilter" cssClass="btn">
                <i class="icon-trash"></i> <s:text name="wao.ui.action.reset"/>
            </s:submit>

            <s:if test="authenticatedWaoUser.authorizedToExportSamplingPlan">
                <s:submit action="export-sampling-plan" type="button" cssClass="btn">
                    <i class="icon-download"></i> <s:text name="wao.ui.action.csvExport" />
                </s:submit>
            </s:if>

            <s:if test="authenticatedWaoUser.authorizedToExportSamplingPlanWithStatistics">
                <s:submit namespace="/obsmer" action="export-sampling-plan-with-statistics" type="button" cssClass="btn">
                    <i class="icon-download"></i> <s:text name="wao.ui.action.exportSamplingPlanCsvWithStatistics" />
                </s:submit>
            </s:if>

        </div>

    </s:form>
    
    <div class="sticky-buttons">

        <button type="button" id="switch-observations-days-view" class="btn">
            <span class="only-in-observations-view">
                <i class="fa fa-calendar"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToDaysView" /></span>
            </span>
            <span class="only-in-days-view">
                <i class="fa fa-anchor"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToObservationsView" /></span>
            </span>
        </button>

        <button type="button" id="switch-compact-full-view" class="btn">
            <span class="only-in-compact-view">
                <i class="fa fa-expand"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToFullView" /></span>
            </span>
            <span class="only-in-full-view">
                <i class="fa fa-compress"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToCompactView" /></span>
            </span>
        </button>
        
        <s:if test="authenticatedWaoUser.authorizedToViewSamplingPlanReal">
            <button type="button" id="switch-estimated-real" class="btn show-estimated">
                <span class="estimated">
                    <i class="fa fa-adjust"></i><span class="only-on-hover">  <s:text name="wao.ui.action.viewReal" /></span>
                </span>
                <span class="real">
                    <i class="fa fa-adjust"></i><span class="only-on-hover"> <s:text name="wao.ui.action.viewEstimated" /></span>
                </span>
            </button>
        </s:if>

    </div>

<s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
    <s:set var="nbColumnsForProfessionInFullView" value="13" />
</s:if>
<s:else>
    <s:set var="nbColumnsForProfessionInFullView" value="12" />
</s:else>
<s:set var="nbColumnsForProfessionInCompactView" value="5" />
<s:set var="nbColumnsForMonths" value="%{samplingPlan.months.size() + 1}" />
<s:set var="nbColumnsForOther" value="5" />
<s:set var="nbColumnsTotalInFullView" value="%{#nbColumnsForProfessionInFullView + #nbColumnsForMonths + #nbColumnsForOther}" />
<s:set var="nbColumnsTotalInCompactView" value="%{#nbColumnsForProfessionInCompactView + #nbColumnsForMonths + #nbColumnsForOther}" />

    <table id="sampling-plan" class="large-table sampling-plan show-estimated">
        <thead>
            <tr>
                <th colspan="<s:property value="#nbColumnsForProfessionInFullView" />" class="only-in-full-view">
                    <s:text name="wao.ui.samplingPlan.sampledProfessions" />
                </th>
                <th colspan="<s:property value="#nbColumnsForProfessionInCompactView" />" class="only-in-compact-view">
                    <s:text name="wao.ui.samplingPlan.sampledProfessions" />
                </th>
                <th colspan="${nbColumnsForMonths}" class="only-in-observations-view">
                    <s:text name="wao.ui.samplingPlan.effort" />

                    <s:if test="authenticatedWaoUser.authorizedToViewSamplingPlanReal">
                        [
                            <span class="estimated">
                                (<s:text name="wao.ui.samplingPlan.actual" /> + <s:text name="wao.ui.samplingPlan.estimated" />)
                            </span>
                            <span class="real">
                                <s:text name="wao.ui.samplingPlan.actual" />
                            </span>
                            /
                            <s:text name="wao.ui.samplingPlan.expected" />
                        ]
                    </s:if>
                </th>
                <th colspan="${nbColumnsForMonths}" class="only-in-days-view">
                    <s:text name="wao.ui.samplingPlan.observationTimesInDays"/>
                    <s:if test="authenticatedWaoUser.authorizedToViewSamplingPlanReal">
                       [
                           <span class="estimated">
                               (<s:text name="wao.ui.samplingPlan.actual" /> + <s:text name="wao.ui.samplingPlan.estimated" />)
                           </span>
                           <span class="real">
                               <s:text name="wao.ui.samplingPlan.actual" />
                           </span>
                           /
                           <s:text name="wao.ui.samplingPlan.expected"/>
                       ]
                    </s:if>
                </th>
                <th colspan="${nbColumnsForOther}"><s:text name="wao.ui.misc.others" /></th>
            </tr>
            <tr>
                <!-- Profession columns -->
                <th><s:text name="wao.ui.field.SampleRow.code"/></th>
                <th><s:text name="wao.ui.samplingPlan.program"/></th>
                <s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
                    <th class="only-in-full-view">
                        <s:text name="wao.ui.entity.Company"/>
                    </th>
                </s:if>
                <th><s:text name="wao.ui.entity.FishingZone"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.samplingPlan.fishingZoneInfo"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.dcf5Code"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.meshSize"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.size"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.other"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.libelle"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.species"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.field.SampleRow.periodBegin"/></th>
                <th class="only-in-full-view"><s:text name="wao.ui.field.SampleRow.periodEnd"/></th>
                <th class="only-in-compact-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.dcf5Code"/></th>
                <th class="only-in-compact-view"><s:text name="wao.ui.misc.METIER"/> <br/> <s:text name="wao.ui.field.SampleRow.libelle"/></th>

                <!-- Months columns -->
                <s:iterator value="samplingPlan.months" var="month">
                    <th class="effort <s:if test="isCurrentMonth(#month)"> now</s:if>">
                        <span class="month"><s:property value="%{formatDateMonth(#month)}"/></span>
                        <span class="year"><s:property value="%{formatDateYear(#month)}"/></span>
                    </th>
                </s:iterator>
                <th><s:text name="wao.ui.misc.total"/></th>

                <!-- Other columns -->
                <th>
                    <s:text name="wao.ui.samplingPlan.averageTideTime"/>
                </th>
                <th>
                    <s:text name="wao.ui.samplingPlan.nbObservants"/>
                </th>
                <th>
                    <s:text name="wao.ui.field.SampleRow.appliedCoverageRate"/>
                </th>
                <th><s:text name="wao.ui.misc.comment"/></th>
                <th><s:text name="wao.ui.samplingPlan.actions"/></th>
            </tr>
        </thead>
        <tbody>

<%--Iterate on Facades--%>
<s:iterator value="samplingPlan" var="samplingPlanFacade">
            <tr class="facade-row">
                <th colspan="${nbColumnsTotalInFullView}" class="facade only-in-full-view">
                    <s:property value="%{#samplingPlanFacade.facade}"/>
                </th>
                <th colspan="${nbColumnsTotalInCompactView}" class="facade only-in-compact-view">
                    <s:property value="%{#samplingPlanFacade.facade}"/>
                </th>
            </tr>
<%--Iterate on Sectors --%>
<s:iterator value="samplingPlanFacade" var="samplingPlanSector">
            <tr class="sector-row">
                <th colspan="${nbColumnsTotalInFullView}" class="sector only-in-full-view">
                    <s:property value="%{#samplingPlanSector.sectors}"/>
                </th>
            </tr>
            <tr class="sector-row">
                <th colspan="${nbColumnsTotalInCompactView}" class="sector only-in-compact-view">
                    <s:property value="%{#samplingPlanSector.sectors}"/>
                </th>
            </tr>
<%--Iterate on SampleRows --%>
<s:iterator value="samplingPlanSector" var="samplingPlanRow">
            <tr class="sample-row-row<s:if test="sampleRowId.equals(sampleRowToHighlightId)"> highlight</s:if>">
                <th>
                    <s:property value="code" />
                    <s:if test="recentlyUpdated">
                        <span class="label label-important">
                            <s:text name="wao.ui.misc.recentUpdate" />
                        </span>
                    </s:if>
                </th>
                <td><s:property value="programName" /></td>
                <s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
                    <td class="only-in-full-view">
                        <s:property value="companyName" />
                    </td>
                </s:if>
                <td class="only-in-full-view"><s:property value="fishingZones" /></td>
                <td class="only-in-compact-view">
                    <s:if test="fishingZonesInfos == null">
                        <s:property value="fishingZones"/>
                    </s:if>
                    <s:else>
                        <span data-original-title="<s:property value="fishingZonesInfos" escapeHtml="false"/>" data-toggle="tooltip" data-placement="left">
                            <s:property value="fishingZones"/>
                        </span>
                    </s:else>
                </td>
                <td class="only-in-full-view">
                    <s:property value="fishingZonesInfos" />
                </td>
                <td class="only-in-full-view">
                    <s:iterator value="dcf5CodesAndDescriptions">
                        <abbr title="<s:property value="value"/>"><s:property value="key"/></abbr>
                    </s:iterator>
                </td>
                <td class="only-in-full-view"><s:property value="professionMeshSize" /></td>
                <td class="only-in-full-view"><s:property value="professionSize" /></td>
                <td class="only-in-full-view"><s:property value="professionOther" /></td>
                <td class="only-in-full-view"><s:property value="professionLibelle" /></td>
                <td class="only-in-full-view"><s:property value="professionSpecies" /></td>
                <td class="only-in-full-view"><s:property value="%{formatMonth(periodBegin)}" /></td>
                <td class="only-in-full-view"><s:property value="%{formatMonth(periodEnd)}" /></td>
                <td class="only-in-compact-view">
                    <s:iterator value="dcf5CodesAndDescriptions">
                        <abbr title="<s:property value="value"/>"><s:property value="key"/></abbr>
                    </s:iterator>
                    <s:property value="professionDescriptionWithoutDCF5" />
                </td>
                <td class="only-in-compact-view">
                    <s:if test="professionSpecies == null">
                        <s:property value="professionLibelle"/>
                    </s:if>
                    <s:else>
                        <span data-original-title="<s:property value="professionSpecies" escapeHtml="false"/>" data-toggle="tooltip" data-placement="left">
                            <s:property value="professionLibelle"/>
                        </span>
                    </s:else>
                </td>
                <!-- Months columns -->
<s:iterator value="samplingPlan.months" var="month">
                <s:set var="effortInObservations" value="#samplingPlanRow.effortInObservationsPerMonths.get(#month)"/>
                <s:set var="effortInDays" value="#samplingPlanRow.effortInDaysPerMonths.get(#month)"/>
                <s:set var="now" value="%{isCurrentMonth(#month)}"/>
                <s:set var="showPercentage" value="false"/>
                <%@include file="../templates/td-effort-obsmer.jsp" %>
</s:iterator>

                <s:set var="effortInObservations" value="#samplingPlanRow.totalObservations"/>
                <s:set var="effortInDays" value="#samplingPlanRow.totalDays"/>
                <s:set var="now" value="false"/>
                <s:set var="showPercentage" value="true"/>
                <%@include file="../templates/td-effort-obsmer.jsp" %>

                <td class="align-center"><s:property value="averageTideTime" /></td>
                <td class="align-center"><s:property value="nbObservants" /></td>
                <td class="align-center">
                    <s:if test="appliedCoverageRate">
                        <s:property value="appliedCoverageRate" />%
                    </s:if>
                </td>
                <td>
                    <s:if test=" ! comment.empty">
                        <i title="<s:property value="comment" escapeHtml="true"/>" class="fa fa-comment"></i>
                    </s:if>
                </td>

                <td class="actions">
                    <div class="dropdown">
                        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
                            <s:text name="wao.ui.actions" />
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu">
                            <s:if test="authenticatedWaoUser.authorizedToEditSamplingPlan">
                                <li>
                                    <s:url action="edit-sample-row!input" id="editSampleRowUrl">
                                        <s:param name="sampleRowId" value="sampleRowId" />
                                    </s:url>
                                    <s:a href="%{editSampleRowUrl}">
                                        <i class="icon-edit"></i> <s:text name="wao.ui.action.editOrDeleteSampleRow" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToViewSampleRowLog">
                                <li>
                                    <s:url action="sample-row-log" id="sampleRowLogUrl">
                                        <s:param name="sampleRowId" value="sampleRowId" />
                                    </s:url>
                                    <s:a href="%{sampleRowLogUrl}">
                                        <i class="icon-time"></i> <s:text name="wao.ui.action.viewSampleRowLog" />
                                    </s:a>
                                </li>
                            </s:if>
                            <li>
                                <s:url action="sampling-plan!applyFilter" id="sampleRowZoomUrl">
                                    <s:param name="filter.periodFrom" value="%{formatMonth(firstSampleMonthDate)}"/>
                                    <s:param name="filter.periodTo" value="%{formatMonth(lastSampleMonthDate)}"/>
                                    <s:param name="filter.companyIds" value="%{filter.companyIds}"/>
                                    <s:param name="filter.programNames" value="%{filter.programNames}"/>
                                    <s:param name="filter.sampleRowCodes" value="%{filter.sampleRowCodes}"/>
                                    <s:param name="filter.fishingZoneFacadeNames" value="%{filter.targetSpeciesDcfIds}"/>
                                    <s:param name="filter.fishingZoneSectorNames" value="%{filter.targetSpeciesDcfIds}"/>
                                    <s:param name="filter.fishingGearDcfIds" value="%{filter.targetSpeciesDcfIds}"/>
                                    <s:param name="filter.targetSpeciesDcfIds" value="%{filter.targetSpeciesDcfIds}"/>
                                </s:url>
                                <s:a href="%{sampleRowZoomUrl}">
                                    <i class="icon-filter"></i> <s:text name="wao.ui.action.zoomOnSampleRowPeriod" />
                                </s:a>
                            </li>
                            <s:if test="authenticatedWaoUser.authorizedToViewBoats && elligibleBoatsProvided">
                                <li>
                                    <s:url action="boats!applyFilter" id="viewElligibleBoatsUrl">
                                        <s:param name="filter.elligibleForSampleRowsFilter.sampleRowCodes" value="code" />
                                    </s:url>
                                    <s:a href="%{viewElligibleBoatsUrl}">
                                        <i class="fa fa-anchor"></i> <s:text name="wao.ui.action.viewElligibleBoats" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToViewContacts && sampleRowContactCounts > 0">
                                <li>
                                    <s:url action="contacts!applyFilter" id="viewAssociatedContactsUrl">
                                        <s:param name="filter.sampleRowFilter.sampleRowCodes" value="code" />
                                        <s:param name="filter.periodFrom" />
                                        <s:param name="filter.periodTo" />
                                    </s:url>
                                    <s:a href="%{viewAssociatedContactsUrl}">
                                         <i class="fa fa-stack-exchange"></i> <s:text name="wao.ui.action.viewAssociatedContacts" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToCreateContact && newContactCreatable">
                                <li>
                                    <s:url action="boats!applyFilter" id="createAssociatedContactUrl">
                                        <s:param name="startBoatSelectionForSampleRowId" value="sampleRowId" />
                                    </s:url>
                                    <s:a href="%{createAssociatedContactUrl}">
                                        <i class="icon-plus"></i> <s:text name="wao.ui.action.createAssociatedContact" />
                                    </s:a>
                                </li>
                            </s:if>
                        </ul>
                    </div>
                </td>
            </tr>
<%--Iterate on SampleRows --%>
</s:iterator>
<%--Iterate on Sectors --%>
</s:iterator>
<%--Iterate on Facades--%>
</s:iterator>

        </todby>
        <tfoot>
            <th colspan="<s:property value="#nbColumnsForProfessionInFullView" />" class="only-in-full-view">
                <s:text name="wao.ui.misc.totals" />
            </th>
            <th colspan="<s:property value="#nbColumnsForProfessionInCompactView" />" class="only-in-compact-view">
                <s:text name="wao.ui.misc.totals" />
            </th>

            <!-- Months columns -->
            <s:iterator value="samplingPlan.months" var="month">
                <s:set var="effortInObservations" value="samplingPlan.totalEffortInObservationsPerMonths.get(#month)"/>
                <s:set var="effortInDays" value="samplingPlan.totalEffortInDaysPerMonths.get(#month)"/>
                <s:set var="now" value="%{isCurrentMonth(#month)}"/>
                <s:set var="showPercentage" value="true"/>
                <%@include file="../templates/td-effort-obsmer.jsp" %>
            </s:iterator>

            <s:set var="effortInObservations" value="samplingPlan.highTotalEffortInObservations"/>
            <s:set var="effortInDays" value="samplingPlan.highTotalEffortInDays"/>
            <s:set var="now" value="false"/>
            <s:set var="showPercentage" value="true"/>
            <%@include file="../templates/td-effort-obsmer.jsp" %>

            <th colspan="${nbColumnsForOther}"></th>

        </tfoot>
    </table>

</html>
