<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
    <head>
        <link rel="stylesheet" type="text/css" href="<s:url value='/bootstrap-wysihtml5-0.0.2/bootstrap-wysihtml5.css' />" />
        <script src="<s:url value='/wysihtml5-0.3.0/wysihtml5.js'/>"></script>
        <script src="<s:url value='/bootstrap-wysihtml5-0.0.2/bootstrap-wysihtml5.js' />"></script>
        <s:if test="!getText('wao.ui.wysihtml5.lang').equals('en')">
            <script src="<s:url value='/bootstrap-wysihtml5-0.0.2/bootstrap-wysihtml5.%{getText("wao.ui.wysihtml5.lang")}.js' />"></script>
        </s:if>
        <script>
            $(document).ready(function () {
                $("#editor").wysihtml5({
                    locale: "<s:property value="%{getText('wao.ui.wysihtml5.lang')}"/>",
                    stylesheets: ["<s:url value='/bootstrap-wysihtml5-0.0.2/wysiwyg-color.css' />"]
                });
             });
        </script>
        <content tag="mainClass">form</content>

    </head>

    <s:form onsubmit="save();">

        <s:hidden name="newsId" value="%{newsId}" />

        <s:textfield name="news.title" label="%{getText('wao.ui.news.title')}" cssClass="input-xxlarge" />

        <s:textarea label="%{getText('wao.ui.news.content')}"
                    name="news.content"
                    id="editor"
                    rows="8"/>

        <div class="form-actions">
            <s:url action="news" id="newsUrl" />
            <s:a href="%{newsUrl}" cssClass="btn">
                <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.cancel" />
            </s:a>

            <s:submit type="button" cssClass="btn">
                <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
            </s:submit>
        </div>

    </s:form>

</html>

