<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

    <head>

        <title><s:text name="wao.ui.page.waoUsers.title" /></title>
        <content tag="mainClass">form</content>
    </head>

    <div class="form-wrapper">
        <h1><s:text name="wao.ui.page.waoUsers.title" /></h1>

        <table class="table table-bordered">
            <tr>
                <th>
                    <s:text name="wao.ui.field.WaoUser.login" />
                </th>
                <th>
                    <s:text name="wao.ui.field.WaoUser.fullName" />
                </th>
                <th>
                    <s:text name="wao.ui.field.WaoUser.active" />
                </th>
                <th>
                    <s:text name="wao.ui.actions" />
                </th>
            </tr>
            <s:iterator value="waoUsers">
                <tr>
                    <td<s:if test=" ! active"> class="inactive"</s:if>>
                        <s:property value="login" />
                    </td>
                    <td>
                        <s:property value="fullName" />
                    </td>
                    <td>
                        <s:if test="active">
                            <s:text name="wao.ui.misc.yes" />
                        </s:if>
                        <s:else>
                            <s:text name="wao.ui.misc.no" />
                        </s:else>
                    </td>
                    <td>
                        <s:url action="edit-wao-user!input" id="editWaoUserUrl">
                            <s:param name="waoUserId" value="topiaId" />
                        </s:url>
                        <s:a href="%{editWaoUserUrl}">
                            <i class="icon-edit"></i> <s:text name="wao.ui.action.edit" />
                        </s:a>

                        <s:url action="delete-wao-user" id="deleteWaoUserUrl">
                            <s:param name="waoUserId" value="topiaId" />
                        </s:url>
                        <s:a href="%{deleteWaoUserUrl}">
                            <i class="icon-trash"></i> <s:text name="wao.ui.action.delete" />
                        </s:a>
                    </td>
                </tr>
            </s:iterator>
        </table>

        <div class="form-actions">
            <s:url action="edit-wao-user!input" id="createWaoUserUrl">
                <s:param name="companyId" value="%{companyId}" />
            </s:url>
            <s:a href="%{createWaoUserUrl}" cssClass="btn float-right">
                <i class="icon-plus"></i> <s:text name="wao.ui.action.createWaoUser" />
            </s:a>
        </div>
    </div>

</html>
