<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
    <head>
        <script>
            $(document).ready(function () {

                var showHideDefinePasswordFunction = function () {
                    var $definePassword = $('#definePassword');
                    var $definePasswordInput = $('input[value="DEFINE_PASSWORD"]');
                    if ($definePasswordInput.prop('checked')) {
                        $definePassword.show();
                    } else {
                        $definePassword.hide();
                    }
                }

                var $updateWaoUserCommandProfessionalInput = $('input[name="updateWaoUserCommand.professional"]');
                var $updateWaoUserCommandProfessionalReadOnlyInput = $('input[name="updateWaoUserCommand.professionalReadOnly"]');

                var showHideDefineCanReadBoatsFunction = function () {
                    var $defineCanReadBoats = $('#defineCanReadBoats');
                    if ($updateWaoUserCommandProfessionalInput.prop('checked') || $updateWaoUserCommandProfessionalReadOnlyInput.prop('checked')) {
                        $defineCanReadBoats.show();
                    } else {
                        $defineCanReadBoats.hide();
                    }
                }

                // bindings
                $('input[name="updateWaoUserCommand.passwordStrategy"]').change(showHideDefinePasswordFunction);
                $updateWaoUserCommandProfessionalInput.change(showHideDefineCanReadBoatsFunction);
                $updateWaoUserCommandProfessionalReadOnlyInput.change(showHideDefineCanReadBoatsFunction);

                // init
                showHideDefinePasswordFunction();
                showHideDefineCanReadBoatsFunction();

            });
        </script>
        <title>
            <s:if test="waoUserId == null">
                <s:text name="wao.ui.form.updateWaoUserCommand.title.creation" />
            </s:if>
            <s:else>
                <s:property value="%{t('wao.ui.form.updateWaoUserCommand.title.edition', updateWaoUserCommand.waoUser.fullName)}" />
            </s:else>
        </title>
        <content tag="mainClass">form</content>
    </head>

    <s:form>

        <h1>
            <s:if test="waoUserId == null">
                <s:text name="wao.ui.form.updateWaoUserCommand.title.creation" />
            </s:if>
            <s:else>
                <s:property value="%{t('wao.ui.form.updateWaoUserCommand.title.edition', updateWaoUserCommand.waoUser.fullName)}" />
            </s:else>
        </h1>

        <s:hidden name="waoUserId" value="%{waoUserId}" />

        <fieldset>

            <legend><s:text name="wao.ui.form.WaoUser.identity" /></legend>

            <s:textfield name="updateWaoUserCommand.waoUser.firstName" label="%{getText('wao.ui.field.WaoUser.firstName')}" requiredLabel="true" />
            <s:textfield name="updateWaoUserCommand.waoUser.lastName" label="%{getText('wao.ui.field.WaoUser.lastName')}" requiredLabel="true" />
            <s:textfield name="updateWaoUserCommand.waoUser.phoneNumber" label="%{getText('wao.ui.field.WaoUser.phoneNumber')}" size="14" />

            <s:if test="authenticatedWaoUser.authorizedToChangeUserCompany">
                <s:select name="updateWaoUserCommand.companyId"
                          label="%{getText('wao.ui.entity.Company')}"
                          list="updateWaoUserCommand.allCompanies"
                          listValue="%{value.name}"
                          requiredLabel="true"
                          cssClass="input-xxlarge" />
            </s:if>
            <s:else>
                <s:hidden name="updateWaoUserCommand.companyId"
                          value="%{updateWaoUserCommand.companyId}"/>
            </s:else>

            <s:if test="authenticatedWaoUser.authorizedToActiveUser">
                <s:checkbox name="updateWaoUserCommand.waoUser.active" label="%{getText('wao.ui.field.WaoUser.active')}" />
            </s:if>

        </fieldset>

        <fieldset>

            <legend><s:text name="wao.ui.form.WaoUser.credentials" /></legend>

            <s:textfield name="updateWaoUserCommand.waoUser.login"
                         label="%{getText('wao.ui.field.WaoUser.login')}"
                         requiredLabel="true"
                         cssClass="input-xlarge" />

            <s:radio name="updateWaoUserCommand.passwordStrategy"
                     label="%{getText('wao.ui.form.updateWaoUserCommand.passwordStrategy')}"
                     listValue="%{getText(top.i18nKey)}"
                     list="updateWaoUserCommand.passwordStrategies"
                     requiredLabel="true" />

            <div id="definePassword">
                <s:textfield type="password" name="updateWaoUserCommand.clearPassword" label="%{getText('wao.ui.field.WaoUser.password')}" />
                <s:textfield type="password" name="updateWaoUserCommand.clearPasswordConfirmation" label="%{getText('wao.ui.form.repeatPassword')}" />
            </div>

        </fieldset>

        <s:if test="authenticatedWaoUser.authorizedToChangeUserRights">
            <fieldset>

                <legend><s:text name="wao.ui.form.WaoUser.rights" /></legend>

                <s:if test="authenticatedWaoUser.authorizedToSetAdmin">
                    <s:checkbox name="updateWaoUserCommand.admin" label="%{getText('wao.ui.form.updateWaoUserCommand.admin')}" />
                    <s:checkbox name="updateWaoUserCommand.adminReadOnly" label="%{getText('wao.ui.form.updateWaoUserCommand.adminReadOnly')}" />
                </s:if>
                <s:if test="authenticatedWaoUser.authorizedToSetCoordinator">
                    <s:checkbox name="updateWaoUserCommand.coordinator" label="%{getText('wao.ui.form.updateWaoUserCommand.coordinator')}" />
                    <s:checkbox name="updateWaoUserCommand.coordinatorReadOnly" label="%{getText('wao.ui.form.updateWaoUserCommand.coordinatorReadOnly')}" />
                </s:if>
                <s:if test="authenticatedWaoUser.authorizedToSetObserver">
                    <s:checkbox name="updateWaoUserCommand.observer" label="%{getText('wao.ui.form.updateWaoUserCommand.observer')}" />
                    <s:checkbox name="updateWaoUserCommand.observerReadOnly" label="%{getText('wao.ui.form.updateWaoUserCommand.observerReadOnly')}" />
                </s:if>
                <s:if test="authenticatedWaoUser.authorizedToSetGuest">
                    <s:checkbox name="updateWaoUserCommand.guest" label="%{getText('wao.ui.form.updateWaoUserCommand.guest')}" />
                    <s:checkbox name="updateWaoUserCommand.guestReadOnly" label="%{getText('wao.ui.form.updateWaoUserCommand.guestReadOnly')}" />
                </s:if>
                <s:if test="authenticatedWaoUser.authorizedToSetProfessional">
                    <s:checkbox name="updateWaoUserCommand.professional" label="%{getText('wao.ui.form.updateWaoUserCommand.professional')}" />
                    <s:checkbox name="updateWaoUserCommand.professionalReadOnly" label="%{getText('wao.ui.form.updateWaoUserCommand.professionalReadOnly')}" />
                    <div id="defineCanReadBoats">
                        <s:textarea name="updateWaoUserCommand.canReadBoats" label="%{getText('wao.ui.form.updateWaoUserCommand.canReadBoats')}" />
                    </div>
                </s:if>

            </fieldset>
        </s:if>

        <s:if test="authenticatedWaoUser.authorizedToAllowUsersToSubscribeToMammalsNotifications">
            <fieldset>
                <legend><s:text name="wao.ui.form.WaoUser.preferences" /></legend>
                <s:checkbox name="updateWaoUserCommand.waoUser.mammalsNotifications" label="%{getText('wao.ui.field.WaoUser.mammalsNotifications')}" />
            </fieldset>
        </s:if>

        <div class="form-actions">
            <s:if test="authenticatedWaoUser.authorizedToViewCompanyUsers">
                <s:url action="wao-users" id="cancelUrl">
                    <s:param name="companyId" value="updateWaoUserCommand.companyId" />
                </s:url>
            </s:if>
            <s:else>
                <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="news" id="cancelUrl" />
            </s:else>
            <s:a href="%{cancelUrl}" cssClass="btn">
                <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.cancel" />
            </s:a>

            <s:submit type="button" cssClass="btn">
                <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
            </s:submit>
        </div>

    </s:form>

</html>
