/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action.administration;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.List;

public class WaoUsersAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected transient WaoUsersService service;
    protected Optional<String> optionalCompanyId = Optional.absent();
    protected List<WaoUser> waoUsers;

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setCompanyId(String companyId) {
        this.optionalCompanyId = Optional.fromNullable((Object)Strings.emptyToNull((String)companyId));
    }

    public String getCompanyId() {
        return (String)this.optionalCompanyId.orNull();
    }

    public void prepare() {
        Preconditions.checkState((boolean)this.getAuthenticatedWaoUser().isAuthorizedToViewCompanyUsers());
        if (this.getAuthenticatedWaoUser().isCoordinator()) {
            this.optionalCompanyId = Optional.of((Object)this.getAuthenticatedWaoUser().getCompany().getTopiaId());
        }
        this.waoUsers = this.service.getWaoUsers(this.optionalCompanyId);
    }

    public List<WaoUser> getWaoUsers() {
        return this.waoUsers;
    }
}

