/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action.administration;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.services.service.administration.LoginMustBeUniqueException;
import fr.ifremer.wao.services.service.administration.UnknownBoatRegistrationCodesException;
import fr.ifremer.wao.services.service.administration.UpdateWaoUserCommand;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.nuiton.util.StringUtil;

@Results(value={@Result(name="success", type="redirectAction", params={"actionName", "wao-users", "companyId", "%{companyId}"}), @Result(name="none", type="redirectAction", params={"actionName", "news"})})
public class EditWaoUserAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected transient WaoUsersService service;
    protected Optional<String> optionalWaoUserId = Optional.absent();
    protected Optional<String> optionalCompanyId = Optional.absent();
    protected UpdateWaoUserCommand updateWaoUserCommand;

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setWaoUserId(String waoUserId) {
        this.optionalWaoUserId = Optional.fromNullable((Object)Strings.emptyToNull((String)waoUserId));
    }

    public void setCompanyId(String companyId) {
        this.optionalCompanyId = Optional.fromNullable((Object)Strings.emptyToNull((String)companyId));
    }

    public void prepare() {
        this.updateWaoUserCommand = this.service.newUpdateWaoUserCommand(this.getObsProgram(), this.optionalWaoUserId, this.optionalCompanyId);
    }

    public void validate() {
        try {
            this.service.preValidate(this.updateWaoUserCommand);
        }
        catch (UnknownBoatRegistrationCodesException unknownBoatRegistrationCodes) {
            this.addFieldError("updateWaoUserCommand.canReadBoats", this.t("wao.ui.unknownBoatRegistrationCodes", new Object[]{Joiner.on((String)", ").join((Iterable)unknownBoatRegistrationCodes.getRegistrationCodes())}));
        }
        catch (LoginMustBeUniqueException e) {
            this.addFieldError("updateWaoUserCommand.waoUser.login", this.t("wao.ui.form.updateWaoUserCommand.error.loginMustBeUnique", new Object[0]));
        }
        if (this.updateWaoUserCommand.getPasswordStrategy().isDefinePassword()) {
            if (StringUtils.isEmpty((CharSequence)this.updateWaoUserCommand.getClearPassword())) {
                this.addFieldError("updateWaoUserCommand.clearPassword", this.t("wao.ui.form.updateWaoUserCommand.missingPassword", new Object[0]));
            }
            if (!this.updateWaoUserCommand.getClearPassword().equals(this.updateWaoUserCommand.getClearPasswordConfirmation())) {
                this.addFieldError("updateWaoUserCommand.clearPasswordConfirmation", this.t("wao.ui.form.updateWaoUserCommand.passwordMismatch", new Object[0]));
            }
        }
        if (!StringUtil.isEmail((String)this.updateWaoUserCommand.getWaoUser().getLogin())) {
            this.addFieldError("updateWaoUserCommand.waoUser.login", this.t("wao.ui.form.updateWaoUserCommand.loginMustBeEmail", new Object[0]));
        }
        if (this.updateWaoUserCommand.getCompanyId() == null) {
            this.addFieldError("updateWaoUserCommand.companyId", this.t("wao.ui.form.updateWaoUserCommand.requiredCompany", new Object[0]));
        }
        if (!this.updateWaoUserCommand.getWaoUser().isActive() && this.updateWaoUserCommand.getPasswordStrategy().isGeneratePassword()) {
            this.addFieldError("updateWaoUserCommand.passwordStrategy", this.t("wao.ui.form.updateWaoUserCommand.illegalPasswordStrategyForInactiveUser", new Object[0]));
        }
    }

    public String execute() {
        this.service.save(this.updateWaoUserCommand);
        this.session.addMessage(this.t("wao.ui.form.updateWaoUserCommand.success", new Object[]{this.updateWaoUserCommand.getWaoUser().getLogin()}));
        this.setCompanyId(this.updateWaoUserCommand.getWaoUser().getCompany().getTopiaId());
        String result = this.getAuthenticatedWaoUser().isAuthorizedToViewCompanyUsers() ? "success" : "none";
        return result;
    }

    public String getWaoUserId() {
        return (String)this.optionalWaoUserId.orNull();
    }

    public String getCompanyId() {
        return (String)this.optionalCompanyId.orNull();
    }

    public UpdateWaoUserCommand getUpdateWaoUserCommand() {
        if (this.updateWaoUserCommand == null) {
            this.prepare();
        }
        return this.updateWaoUserCommand;
    }
}

