/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.MoreObjects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.services.service.Synthesis;
import fr.ifremer.wao.services.service.SynthesisService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.Locale;
import org.nuiton.i18n.I18n;

public class SynthesisAction
extends WaoJspActionSupport
implements Preparable {
    protected ContactsFilter filter;
    protected SynthesisService service;
    protected Synthesis synthesis;

    public void setService(SynthesisService service) {
        this.service = service;
    }

    public ContactsFilter getFilter() {
        if (this.filter == null) {
            this.prepare();
        }
        return this.filter;
    }

    public void prepare() {
        if (this.filter == null) {
            this.filter = this.service.newFilter(this.getAuthenticatedWaoUser());
        }
    }

    public void validate() {
        if (this.filter.getPeriodFrom() != null && this.filter.getPeriodTo() != null && this.filter.getPeriodTo().before(this.filter.getPeriodFrom())) {
            this.addFieldError("filter.periodTo", I18n.l((Locale)this.getLocale(), (String)"wao.ui.periodToMustBeAfterPeriodFrom", (Object[])new Object[0]));
        }
    }

    public String execute() {
        this.filter = (ContactsFilter)MoreObjects.firstNonNull((Object)this.session.getSynthesisFilter(), (Object)this.filter);
        return this.applyFilter();
    }

    public String resetFilter() {
        this.filter = this.service.newFilter(this.getAuthenticatedWaoUser());
        return this.applyFilter();
    }

    public String applyFilter() {
        this.getSession().setSynthesisFilter(this.filter);
        this.synthesis = this.service.getSynthesis(this.filter);
        return "success";
    }

    public Synthesis getSynthesis() {
        return this.synthesis;
    }
}

