/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.News;
import fr.ifremer.wao.services.service.administration.NewsService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

@Results(value={@Result(name="success", type="redirectAction", params={"actionName", "news"})})
public class EditNewsAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected static final Whitelist WHITE_LIST = Whitelist.basicWithImages().addTags(new String[]{"h1", "h2", "h3"});
    protected transient NewsService service;
    protected String newsId;
    protected News news;

    public void setService(NewsService service) {
        this.service = service;
    }

    public void setNewsId(String newsId) {
        this.newsId = newsId;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public void prepare() {
        this.news = StringUtils.isEmpty((CharSequence)this.newsId) ? this.service.newNews(this.getAuthenticatedWaoUser()) : this.service.getNews(this.newsId);
    }

    public String execute() {
        String clean = Jsoup.clean((String)this.news.getContent(), (Whitelist)WHITE_LIST);
        this.news.setContent(clean);
        this.service.save(this.news);
        this.addActionMessage(this.t("wao.ui.action.createNews.success", new Object[0]));
        return "success";
    }

    public String getNewsId() {
        return this.newsId;
    }

    public News getNews() {
        return this.news;
    }
}

