package fr.ifremer.wao.web.converter;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.WaoUtils;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;


/**
 * To convert a date as a month.
 *
 * @see WaoUtils#parseMonth(Locale, String)
 * @see WaoUtils#formatMonth(Locale, Date)
 * @since 4.0
 */
public class MonthConverter extends AbstractDateConverter {

    @Override
    protected Date parse(Locale locale, String string) throws ParseException {
        return WaoUtils.parseMonth(locale, string);
    }

    @Override
    protected String format(Locale locale, Date date) {
        return WaoUtils.formatMonth(locale, date);
    }
}
