package fr.ifremer.wao.web.converter;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.io.BaseEncoding;
import fr.ifremer.wao.WaoTechnicalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

public class JFreeChartToImgTagConverter extends StrutsTypeConverter {

    private static final Log log = LogFactory.getLog(JFreeChartToImgTagConverter.class);

    @Override
    public Object convertFromString(Map context, String[] values, Class toClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String convertToString(Map context, Object o) {

        // XXX brendan 28/10/14 inutile de lancer une exception... C'est perdu par struts

        if (o instanceof JFreeChart) {

            JFreeChart chart = (JFreeChart) o;

            ByteArrayOutputStream output = new ByteArrayOutputStream();

            try {
                ChartUtilities.writeChartAsPNG(output, chart, 1000, 600);
            } catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("unable to write chart to PNG", e);
                }
                throw new WaoTechnicalException("unable to write chart to PNG", e);
            }

            byte[] bytes = output.toByteArray();

            String base64code = BaseEncoding.base64().encode(bytes);

            String html = "<img alt=\"" + chart.getTitle().getText() + "\" src=\"data:image/png;base64," + base64code + "\" />";

            return html;

        } else {
            if (log.isErrorEnabled()) {
                log.error("unable to convert " + o);
            }
            throw new UnsupportedOperationException("unable to convert " + o);
        }

    }

}
