package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.services.service.administration.ReferentialService;
import fr.ifremer.wao.services.service.administration.ReferentialState;
import fr.ifremer.wao.web.WaoJspActionSupport;

import java.util.List;

public class ReferentialManagementAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient ReferentialService referentialService;

    protected List<ReferentialState> referentialStates;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    public void prepare() {

        Preconditions.checkState(getAuthenticatedWaoUser().isAuthorizedToUpdateReferential());

        referentialStates = referentialService.getReferentialStates(getObsProgram());

    }

    public List<ReferentialState> getReferentialStates() {
        return referentialStates;
    }

}
