package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.BoatDetails;
import fr.ifremer.wao.services.service.BoatsService;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.web.WaoJspActionSupport;

import java.util.List;

public class BoatDetailsAction extends WaoJspActionSupport {

    private static final long serialVersionUID = 1L;

    protected transient BoatsService service;

    protected transient SamplingPlanService samplingPlanService;

    protected String companyId;

    protected String boatId;

    protected BoatDetails boatDetails;

    protected SampleRow startBoatSelectionForSampleRow;

    private List<SampleRow> sampleRowsToSetElligible;

    public void setService(BoatsService service) {
        this.service = service;
    }

    public void setSamplingPlanService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setBoatId(String boatId) {
        this.boatId = boatId;
    }

    @Override
    public String execute() {

        Preconditions.checkState(getAuthenticatedWaoUser().isAuthorizedToViewBoatDetails(companyId));

        boatDetails = service.getBoatDetails(getObsProgram(), boatId, companyId);

        String startBoatSelectionForSampleRowId = session.getStartBoatSelectionForSampleRowId();

        if (startBoatSelectionForSampleRowId != null) {
            startBoatSelectionForSampleRow = samplingPlanService.getSampleRow(startBoatSelectionForSampleRowId);
        }

        // TODO brendan 14/04/14 really useful ?
        sampleRowsToSetElligible = samplingPlanService.getUnfinishedSampleRows(getAuthenticatedWaoUser(), companyId);

        return SUCCESS;

    }

    public BoatDetails getBoatDetails() {
        return boatDetails;
    }

    public SampleRow getStartBoatSelectionForSampleRow() {
        return startBoatSelectionForSampleRow;
    }

    public List<SampleRow> getSampleRowsToSetElligible() {
        return sampleRowsToSetElligible;
    }
}
