package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.BoatInfos;
import fr.ifremer.wao.services.service.BoatsService;
import fr.ifremer.wao.web.WaoJsonActionSupport;

public class UpdateBoatInfosJsonAction extends WaoJsonActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient BoatsService service;

    protected String companyId;

    protected String boatId;

    protected BoatInfos boatInfos;

    public void setService(BoatsService service) {
        this.service = service;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setBoatId(String boatId) {
        this.boatId = boatId;
    }

    @Override
    public void prepare() {

        Preconditions.checkState(session.getAuthenticatedWaoUser().isAuthorizedToViewBoatDetails(companyId));

        boatInfos = service.getBoatInfos(boatId, companyId);

    }

    public BoatInfos getBoatInfos() {
        return boatInfos;
    }

    public void setBoatInfos(BoatInfos boatInfos) {
        this.boatInfos = boatInfos;
    }

    @Override
    public String execute() {

        service.saveBoatInfos(boatInfos);

        return SUCCESS;

    }

}
