package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.services.service.ImportErrorException;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import java.io.InputStream;

/**
 * Created on 4/3/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 4.0
 */
@Results({
     @Result(name = "error", type = "redirectAction", params = {"actionName", "import-contacts!input"}),
     @Result(name = "success", type = "redirectAction", params = {"actionName", "contacts"})
 })
public class ImportContactsAction extends AbstractImportCsvAction {

    private static final long serialVersionUID = 1L;

    protected transient ContactsService contactsService;

    public void setContactsService(ContactsService contactsService) {
        this.contactsService = contactsService;
    }

    @Override
    protected void importCsv(InputStream csvInputStream) throws ImportErrorException {
        contactsService.importContacts(getAuthenticatedWaoUser(), csvInputStream);
    }

    @Override
    protected String getSuccessMessage() {
        return t("wao.ui.import.contacts.success");
    }

}