package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.services.service.ContactsService;

import java.io.InputStream;
import java.util.Date;

/**
 * Created on 4/3/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 4.0
 */
public class ExportContactsAction extends AbstractDownloadCsvAction implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient ContactsService service;

    protected ContactsFilter filter;

    public void setService(ContactsService service) {
        this.service = service;
    }

    public ContactsFilter getFilter() {
        if (filter == null) {
            prepare();
        }
        return filter;
    }

    @Override
    public void prepare() {

        filter = service.newContactFilter(getAuthenticatedWaoUser());
    }

    @Override
    public String getFileName() {

        return "contacts_" + getObsProgram().name() + "_" + dateFormat.format(new Date()) + ".csv";
    }

    @Override
    public InputStream getInputStream() {

        return service.exportContacts(filter);
    }

}