package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.WaoApplicationConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.struts2.BaseAction;

import java.util.Locale;

public class WaoActionSupport extends BaseAction {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(WaoActionSupport.class);

    protected WaoApplicationConfig applicationConfig;

    protected WaoSession session;

    public void setApplicationConfig(WaoApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public WaoApplicationConfig getApplicationConfig() {
        return applicationConfig;
    }

    public void setSession(WaoSession session) {
        this.session = session;
    }

    public void set_(String _) {
        // ignore jQuery timestamp
    }

    public void setFragment(boolean fragment) {
        // ignore fragment get parameter: it's managed by sitemesh decorators
    }

    @Override
    public Locale getLocale() {
        Locale locale = super.getLocale();
        if (log.isDebugEnabled()) {
            log.debug("locale is " + locale);
        }
        return locale;
    }
}
