package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results({
        @Result(name="success", type="redirectAction", params = { "actionName", "contacts" })
})
public class CreateContactAction extends WaoJspActionSupport {

    protected ContactsService service;

    protected String boatId;

    protected String sampleRowId;

    public void setService(ContactsService service) {
        this.service = service;
    }

    public void setBoatId(String boatId) {
        this.boatId = boatId;
    }

    public void setSampleRowId(String sampleRowId) {
        this.sampleRowId = sampleRowId;
    }

    @Override
    public String execute() {

        Contact contact = service.createContact(getAuthenticatedWaoUser(), sampleRowId, boatId);

        session.setStartBoatSelectionForSampleRowId(null);

        session.setContactToHighlightId(contact.getTopiaId());

        return SUCCESS;

    }

}
