package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import fr.ifremer.wao.WaoTechnicalException;
import fr.ifremer.wao.services.WaoWebApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;

public class DefaultWaoWebApplicationContext implements WaoWebApplicationContext {

    private static final Log log = LogFactory.getLog(DefaultWaoWebApplicationContext.class);

    protected String instanceUrl;

    public DefaultWaoWebApplicationContext(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected String formatUrl(String actionUrl) {
        Map<String, String> emptyMap = Collections.emptyMap();
        return formatUrl(actionUrl, emptyMap);
    }

    protected String formatUrl(String actionUrl, Map<String, String> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(instanceUrl).append("/").append(actionUrl);
        if ( ! parameters.isEmpty()) {
            SortedSet<String> queryStringElements = Sets.newTreeSet();
            try {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    String queryStringElement = parameter.getKey() + '=' + URLEncoder.encode(parameter.getValue(), Charsets.UTF_8.name());
                    queryStringElements.add(queryStringElement);
                }
            } catch (UnsupportedEncodingException e) {
                if (log.isErrorEnabled()) {
                    log.error("should never occur", e);
                }
                throw new WaoTechnicalException(e);
            }
            stringBuilder.append('?').append(Joiner.on('&').join(queryStringElements));
        }
        return stringBuilder.toString();
    }

}
