/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicBean;
import fr.ifremer.tutti.service.cruise.CruiseCache;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingCacheRequest;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.AverageWeightsHistogramModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequenciesHistogramModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingCodeUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModelCache;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpeciesFrequencyUIModel
extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";
    public static final String PROPERTY_FREQUENCIES_CONFIGURATION_MODE = "frequenciesConfigurationMode";
    public static final String PROPERTY_STEP = "step";
    private static final String PROPERTY_MIN_STEP = "minStep";
    private static final String PROPERTY_MAX_STEP = "maxStep";
    public static final String PROPERTY_CAN_GENERATE = "canGenerate";
    public static final String PROPERTY_FREQUENCIES_MODE = "frequenciesMode";
    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";
    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";
    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";
    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT = "lengthStepCaracteristicUnit";
    public static final String PROPERTY_TOTAL_NUMBER = "totalNumber";
    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";
    public static final String PROPERTY_TOTAL_COMPUTED_WEIGHT = "totalComputedWeight";
    public static final String PROPERTY_COPY_RTP_WEIGHTS = "copyRtpWeights";
    public static final String PROPERTY_RTP = "rtp";
    public static final String PROPERTY_ADD_INDIVIDUAL_OBSERVATION_ON_RAFALE = "addIndividualObservationOnRafale";
    public static final String PROPERTY_FREQUENCIES_COLOR = "frequenciesColor";
    public static final String PROPERTY_INDIVIDUAL_OBSERVATION_COLOR = "individualObservationColor";
    public static final String PROPERTY_EMPTY_ROWS = "emptyRows";
    public static final String PROPERTY_NEXT_EDITABLE_ROW_INDEX = "nextEditableRowIndex";
    public static final String PROPERTY_CAN_EDIT_LENGTH_STEP = "canEditLengthStep";
    public static final String PROPERTY_CAN_GO_PREV_BATCH = "canGoPrevBatch";
    public static final String PROPERTY_CAN_GO_NEXT_BATCH = "canGoNextBatch";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_MODE = "copyIndividualObservationMode";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_ALL = "copyIndividualObservationAll";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_NOTHING = "copyIndividualObservationNothing";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_SIZE = "copyIndividualObservationSize";
    public static final String PROPERTY_INIT_BATCH_EDITION = "initBatchEdition";
    public static final String PROPERTY_NON_EMPTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR = "nonEmptyIndividualObservationRowsInError";
    private final SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;
    private FrequencyConfigurationMode configurationMode;
    private FrequencyConfigurationMode frequenciesConfigurationMode;
    private FishingOperation fishingOperation;
    private SpeciesBatchRowModel batch;
    private Float step;
    private Float minStep;
    private Float maxStep;
    private Caracteristic lengthStepCaracteristic;
    private Integer totalNumber;
    private ComputableData<Float> totalComputedOrNotWeight;
    private Rtp rtp;
    private boolean copyRtpWeights;
    private boolean addIndividualObservationOnRafale;
    private Integer simpleCount;
    private Integer nextEditableRowIndex;
    private Set<SpeciesFrequencyRowModel> emptyRows;
    private final SampleCategoryModel sampleCategoryModel;
    private final WeightUnit weightUnit;
    private final WeightUnit individualObservationWeightUnit;
    private final SpeciesFrequencyUIModelCache cache;
    private boolean canEditLengthStep;
    private CopyIndividualObservationMode copyIndividualObservationMode;
    private boolean canGoPrevBatch = true;
    private boolean canGoNextBatch = true;
    private boolean initBatchEdition;
    private final AverageWeightsHistogramModel averageWeightsHistogramModel;
    private final FrequenciesHistogramModel frequenciesHistogramModel;
    private final IndividualObservationBatchUIModel individualObservationModel;
    private final IndividualObservationUICache individualObservationUICache;
    private final SamplingCodeUICache samplingCodeUICache;
    private SpeciesFrequencyTableModel frequencyTableModel;
    private final boolean protocolFilled;
    private final boolean protocolUseCalcifiedPieceSampling;
    private boolean nonEmptyIndividualObservationRowsInError;

    public SpeciesFrequencyUIModel(SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport, WeightUnit individualObservationWeightUnit, SampleCategoryModel sampleCategoryModel, Caracteristic sexCaracteristic, List<Caracteristic> protocolIndividualObservationCaracteristics, CruiseCache cruiseCache, Integer cruiseId, TuttiProtocol protocol) {
        super(SpeciesBatchRowModel.class, null, null);
        this.protocolFilled = protocol != null;
        this.protocolUseCalcifiedPieceSampling = this.protocolFilled && protocol.isUseCalcifiedPieceSampling();
        this.speciesOrBenthosBatchUISupport = speciesOrBenthosBatchUISupport;
        this.weightUnit = speciesOrBenthosBatchUISupport.getWeightUnit();
        this.individualObservationWeightUnit = individualObservationWeightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.totalComputedOrNotWeight = new ComputableData();
        this.totalComputedOrNotWeight.addPropagateListener(PROPERTY_TOTAL_WEIGHT, this);
        this.copyIndividualObservationMode = CopyIndividualObservationMode.NOTHING;
        this.canEditLengthStep = true;
        this.cache = new SpeciesFrequencyUIModelCache();
        this.frequenciesConfigurationMode = FrequencyConfigurationMode.RAFALE;
        this.setEmptyRows(new HashSet<SpeciesFrequencyRowModel>());
        this.individualObservationModel = new IndividualObservationBatchUIModel(this, sexCaracteristic, protocolIndividualObservationCaracteristics);
        this.averageWeightsHistogramModel = new AverageWeightsHistogramModel(this.weightUnit);
        this.frequenciesHistogramModel = new FrequenciesHistogramModel();
        this.individualObservationUICache = new IndividualObservationUICache(cruiseCache, this);
        this.samplingCodeUICache = new SamplingCodeUICache(cruiseCache.getSamplingCodeCache(), this, cruiseId);
    }

    public SpeciesFrequencyUIModelCache getCache() {
        return this.cache;
    }

    public SamplingCodeUICache getSamplingCodeUICache() {
        return this.samplingCodeUICache;
    }

    public IndividualObservationUICache getIndividualObservationUICache() {
        return this.individualObservationUICache;
    }

    public AverageWeightsHistogramModel getAverageWeightsHistogramModel() {
        return this.averageWeightsHistogramModel;
    }

    public FrequenciesHistogramModel getFrequenciesHistogramModel() {
        return this.frequenciesHistogramModel;
    }

    public WeightUnit getWeightUnit() {
        return this.weightUnit;
    }

    public boolean isInitBatchEdition() {
        return this.initBatchEdition;
    }

    public void setInitBatchEdition(boolean initBatchEdition) {
        Boolean oldValue = this.isInitBatchEdition();
        this.initBatchEdition = initBatchEdition;
        this.firePropertyChange(PROPERTY_INIT_BATCH_EDITION, oldValue, initBatchEdition);
    }

    public void reloadRows() {
        this.setEmptyRows(new HashSet<SpeciesFrequencyRowModel>());
        this.cache.loadCache(this.rows);
        this.recomputeRowsValidateState();
        this.frequenciesHistogramModel.reloadRows(this.rows);
        this.averageWeightsHistogramModel.reloadRows(this.rows);
        this.recomputeTotalNumber();
        this.recomputeTotalWeight();
    }

    public boolean isRowValid(SpeciesFrequencyRowModel row) {
        boolean valid;
        boolean bl = valid = row.getLengthStepCaracteristic() != null;
        if (valid) {
            Float lengthStep = row.getLengthStep();
            boolean bl2 = valid = lengthStep != null && lengthStep.floatValue() > 0.0f && this.cache.numberOfRows(lengthStep.floatValue()) < 2;
        }
        if (valid) {
            valid = row.withNumber();
        }
        if (valid) {
            valid = this.getNbRowsWithWeight() == 0 || row.withWeight();
        }
        return valid;
    }

    @Override
    protected SpeciesBatchRowModel newEntity() {
        return new SpeciesBatchRowModel(this.weightUnit, this.sampleCategoryModel);
    }

    public FrequencyConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(FrequencyConfigurationMode configurationMode) {
        FrequencyConfigurationMode oldValue = this.getConfigurationMode();
        this.configurationMode = configurationMode;
        this.firePropertyChange(PROPERTY_FREQUENCIES_MODE, null, this.isFrequenciesMode());
        this.firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, this.isSimpleCountingMode());
        this.firePropertyChange(PROPERTY_CONFIGURATION_MODE, (Object)oldValue, (Object)configurationMode);
    }

    public FrequencyConfigurationMode getFrequenciesConfigurationMode() {
        return this.frequenciesConfigurationMode;
    }

    public void setFrequenciesConfigurationMode(FrequencyConfigurationMode frequenciesConfigurationMode) {
        FrequencyConfigurationMode oldValue = this.getFrequenciesConfigurationMode();
        this.frequenciesConfigurationMode = frequenciesConfigurationMode;
        this.firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, this.isAutoGenMode());
        this.firePropertyChange(PROPERTY_RAFALE_MODE, null, this.isRafaleMode());
        this.firePropertyChange(PROPERTY_FREQUENCIES_CONFIGURATION_MODE, (Object)oldValue, (Object)this.getFrequenciesConfigurationMode());
    }

    public Float getStep() {
        return this.step;
    }

    public void setStep(Caracteristic caracteristic) {
        Float step = null;
        if (caracteristic != null) {
            step = caracteristic.getPrecision();
        }
        if (step == null) {
            step = CaracteristicBean.DEFAULT_PRECISION;
        }
        this.setStep(step);
    }

    public void setStep(Float step) {
        Float oldValue = this.getStep();
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT, null, this.getLengthStepCaracteristicUnit());
    }

    public String getLengthStepCaracteristicUnit() {
        return this.lengthStepCaracteristic == null ? null : this.lengthStepCaracteristic.getUnit();
    }

    public float convertFromMm(float source) {
        return Numbers.convertFromMm((float)source, (String)this.getLengthStepCaracteristicUnit());
    }

    public Float getMinStep() {
        return this.minStep;
    }

    public void setMinStep(Float minStep) {
        Float oldValue = this.getMinStep();
        this.minStep = minStep;
        this.firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Float oldValue = this.getMaxStep();
        this.maxStep = maxStep;
        this.firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Integer getSimpleCount() {
        return this.simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Integer oldValue = this.getSimpleCount();
        this.simpleCount = simpleCount;
        this.firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public boolean isCanEditLengthStep() {
        return this.canEditLengthStep;
    }

    public void setCanEditLengthStep(boolean canEditLengthStep) {
        Boolean oldValue = this.isCanEditLengthStep();
        this.canEditLengthStep = canEditLengthStep;
        this.firePropertyChange(PROPERTY_CAN_EDIT_LENGTH_STEP, oldValue, canEditLengthStep);
    }

    public Integer getNextEditableRowIndex() {
        return this.nextEditableRowIndex;
    }

    public void setNextEditableRowIndex(Integer nextEditableRowIndex) {
        Integer oldValue = this.getNextEditableRowIndex();
        this.nextEditableRowIndex = nextEditableRowIndex;
        this.firePropertyChange(PROPERTY_NEXT_EDITABLE_ROW_INDEX, oldValue, nextEditableRowIndex);
    }

    public boolean isSimpleCountingMode() {
        return FrequencyConfigurationMode.SIMPLE_COUNTING == this.configurationMode;
    }

    public boolean isFrequenciesMode() {
        return FrequencyConfigurationMode.FREQUENCIES == this.configurationMode;
    }

    public boolean isAutoGenMode() {
        return FrequencyConfigurationMode.AUTO_GEN == this.frequenciesConfigurationMode;
    }

    public boolean isRafaleMode() {
        return FrequencyConfigurationMode.RAFALE == this.frequenciesConfigurationMode;
    }

    public boolean isCanGenerate() {
        return this.minStep != null && this.maxStep != null && this.maxStep.floatValue() > this.minStep.floatValue() && this.lengthStepCaracteristic != null;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public SpeciesBatchRowModel getBatch() {
        return this.batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        this.batch = batch;
        this.firePropertyChange(PROPERTY_BATCH, null, batch);
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int)(lengthStep * 10.0f);
        int intStep = (int)(this.step.floatValue() * 10.0f);
        int correctIntStep = intValue - intValue % intStep;
        return (float)correctIntStep / 10.0f;
    }

    public Integer getLengthStepInMm(Float lengthStep) {
        Integer lengthClass;
        Caracteristic c = this.getLengthStepCaracteristic();
        if (c != null && c.getPrecision().equals(this.step)) {
            lengthClass = c.getLengthStepInMm(lengthStep);
        } else if (lengthStep == null) {
            lengthClass = null;
        } else {
            int intValue = (int)(lengthStep.floatValue() * 10.0f);
            int intStep = (int)(this.step.floatValue() * 10.0f);
            int correctIntStep = intValue - intValue % intStep;
            lengthClass = Numbers.convertToMm((float)((float)correctIntStep / 10.0f), (String)this.getLengthStepCaracteristicUnit());
        }
        return lengthClass;
    }

    public Integer getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        Integer oldValue = this.getTotalNumber();
        this.totalNumber = totalNumber;
        this.firePropertyChange(PROPERTY_TOTAL_NUMBER, oldValue, totalNumber);
    }

    public ComputableData<Float> getTotalComputedOrNotWeight() {
        return this.totalComputedOrNotWeight;
    }

    public Float getTotalWeight() {
        return this.totalComputedOrNotWeight.getData();
    }

    public void setTotalWeight(Float totalWeight) {
        Float oldValue = this.getTotalWeight();
        this.totalComputedOrNotWeight.setData(this.weightUnit.round(totalWeight));
        this.firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getTotalComputedWeight() {
        return this.totalComputedOrNotWeight.getComputedData();
    }

    public void setTotalComputedWeight(Float totalComputedWeight) {
        Float oldValue = this.getTotalComputedWeight();
        this.totalComputedOrNotWeight.setComputedData(this.weightUnit.round(totalComputedWeight));
        this.firePropertyChange(PROPERTY_TOTAL_COMPUTED_WEIGHT, oldValue, totalComputedWeight);
    }

    public boolean isTotalWeightSameAsComputedWeight() {
        Float totalWeight = this.getTotalWeight();
        Float totalComputedWeight = this.getTotalComputedWeight();
        return totalWeight != null && totalComputedWeight != null && WeightUnit.KG.isEquals(totalWeight.floatValue(), totalComputedWeight.floatValue());
    }

    public Rtp getRtp() {
        return this.rtp;
    }

    public void setRtp(Rtp rtp) {
        Rtp oldValue = this.getRtp();
        this.rtp = rtp;
        this.firePropertyChange(PROPERTY_RTP, oldValue, rtp);
    }

    public boolean isCopyRtpWeights() {
        return this.copyRtpWeights;
    }

    public void setCopyRtpWeights(boolean copyRtpWeights) {
        boolean oldValue = this.isCopyRtpWeights();
        try {
            this.fireVetoableChange(PROPERTY_COPY_RTP_WEIGHTS, oldValue, copyRtpWeights);
            this.copyRtpWeights = copyRtpWeights;
            this.firePropertyChange(PROPERTY_COPY_RTP_WEIGHTS, oldValue, copyRtpWeights);
        }
        catch (PropertyVetoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error in setting copyRtpWeights", (Throwable)e);
            }
            this.firePropertyChange(PROPERTY_COPY_RTP_WEIGHTS, copyRtpWeights, oldValue);
        }
    }

    public CopyIndividualObservationMode getCopyIndividualObservationMode() {
        return this.copyIndividualObservationMode;
    }

    public void setCopyIndividualObservationMode(CopyIndividualObservationMode copyIndividualObservationMode) {
        Color oldFrequenciesColor = this.getFrequenciesColor();
        Color oldIndividualObservationColor = this.getIndividualObservationColor();
        CopyIndividualObservationMode oldValue = this.getCopyIndividualObservationMode();
        boolean oldCopyAll = this.isCopyIndividualObservationAll();
        boolean oldCopyNothing = this.isCopyIndividualObservationNothing();
        boolean oldCopySize = this.isCopyIndividualObservationSize();
        this.copyIndividualObservationMode = copyIndividualObservationMode;
        this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_ALL, oldCopyAll, this.isCopyIndividualObservationAll());
        this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_NOTHING, oldCopyNothing, this.isCopyIndividualObservationNothing());
        this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_SIZE, oldCopySize, this.isCopyIndividualObservationSize());
        this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_MODE, oldValue, this.getCopyIndividualObservationMode());
        this.firePropertyChange(PROPERTY_FREQUENCIES_COLOR, oldFrequenciesColor, this.getFrequenciesColor());
        this.firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_COLOR, oldIndividualObservationColor, this.getIndividualObservationColor());
    }

    public boolean mustCopyIndividualObservationSize() {
        return this.isCopyIndividualObservationAll() || this.isCopyIndividualObservationSize();
    }

    public boolean isCopyIndividualObservationAll() {
        return CopyIndividualObservationMode.ALL == this.copyIndividualObservationMode;
    }

    public boolean isCopyIndividualObservationNothing() {
        return CopyIndividualObservationMode.NOTHING == this.copyIndividualObservationMode;
    }

    public boolean isCopyIndividualObservationSize() {
        return CopyIndividualObservationMode.SIZE == this.copyIndividualObservationMode;
    }

    public boolean isCanGoPrevBatch() {
        return this.canGoPrevBatch;
    }

    public void setCanGoPrevBatch(boolean canGoPrevBatch) {
        boolean old = this.canGoPrevBatch;
        this.canGoPrevBatch = canGoPrevBatch;
        this.firePropertyChange(PROPERTY_CAN_GO_PREV_BATCH, old, canGoPrevBatch);
    }

    public boolean isCanGoNextBatch() {
        return this.canGoNextBatch;
    }

    public void setCanGoNextBatch(boolean canGoNextBatch) {
        boolean old = this.canGoNextBatch;
        this.canGoNextBatch = canGoNextBatch;
        this.firePropertyChange(PROPERTY_CAN_GO_NEXT_BATCH, old, canGoNextBatch);
    }

    public Set<SpeciesFrequencyRowModel> getEmptyRows() {
        return this.emptyRows;
    }

    public void setEmptyRows(Set<SpeciesFrequencyRowModel> emptyRows) {
        this.emptyRows = emptyRows;
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, emptyRows);
    }

    public boolean isAddIndividualObservationOnRafale() {
        return this.addIndividualObservationOnRafale;
    }

    public void setAddIndividualObservationOnRafale(boolean addIndividualObservationOnRafale) {
        Color oldFrequenciesColor = this.getFrequenciesColor();
        Color oldIndividualObservationColor = this.getIndividualObservationColor();
        Boolean oldValue = this.isAddIndividualObservationOnRafale();
        this.addIndividualObservationOnRafale = addIndividualObservationOnRafale;
        this.firePropertyChange(PROPERTY_ADD_INDIVIDUAL_OBSERVATION_ON_RAFALE, oldValue, addIndividualObservationOnRafale);
        this.firePropertyChange(PROPERTY_FREQUENCIES_COLOR, oldFrequenciesColor, this.getFrequenciesColor());
        this.firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_COLOR, oldIndividualObservationColor, this.getIndividualObservationColor());
    }

    public Color getFrequenciesColor() {
        Color result = UIManager.getColor("JXTitledPanel.titleBackground");
        if (this.isAddIndividualObservationOnRafale()) {
            if (this.isCopyIndividualObservationAll()) {
                result = Color.GREEN;
            } else if (this.isCopyIndividualObservationSize()) {
                result = new Color(0, 255, 140);
            }
        } else {
            result = Color.GREEN;
        }
        return result;
    }

    public Color getIndividualObservationColor() {
        Color result = UIManager.getColor("JXTitledPanel.titleBackground");
        if (this.isAddIndividualObservationOnRafale()) {
            result = Color.GREEN;
        }
        return result;
    }

    public int getNbRowsWithWeight() {
        return this.cache.getNbRowsWithWeight();
    }

    public boolean isSomeRowsWithWeightAndOtherWithout() {
        boolean result;
        if (CollectionUtils.isEmpty((Collection)this.rows)) {
            result = false;
        } else {
            int nbNoneEmptyRows = 0;
            int nbNoneEmptyRowsWithWeight = 0;
            for (SpeciesFrequencyRowModel row : this.rows) {
                if (row.isEmpty()) continue;
                ++nbNoneEmptyRows;
                if (row.getWeight() == null) continue;
                ++nbNoneEmptyRowsWithWeight;
            }
            result = nbNoneEmptyRowsWithWeight > 0 && nbNoneEmptyRows != nbNoneEmptyRowsWithWeight;
        }
        return result;
    }

    public void updateEmptyRow(SpeciesFrequencyRowModel row) {
        if (row.isValid() && row.getNumber() == null && row.getWeight() == null) {
            this.emptyRows.add(row);
        } else {
            this.emptyRows.remove(row);
        }
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    public void recomputeTotalWeight() {
        Float computeTotalWeight = this.cache.computeTotalWeight();
        this.setTotalComputedWeight(computeTotalWeight);
    }

    public void recomputeTotalNumber() {
        int computeTotalNumber = 0;
        if (this.rows != null) {
            for (SpeciesFrequencyRowModel row : this.rows) {
                if (!row.isValid() || row.getNumber() == null) continue;
                computeTotalNumber += row.getNumber().intValue();
            }
        }
        this.setTotalNumber(computeTotalNumber);
    }

    public void recomputeCanEditLengthStep() {
        boolean result = this.frequencyTableModel.recomputeCanEditLengthStep();
        if (result) {
            result = this.individualObservationModel.recomputeCanEditLengthStep();
        }
        this.setCanEditLengthStep(result);
    }

    public void computeRowWeightWithRtp() {
        this.rows.forEach(this::computeRowWeightWithRtp);
    }

    public void computeRowWeightWithRtp(SpeciesFrequencyRowModel row) {
        Float computedWeight = null;
        if (row.withNumber() && row.getLengthStep() != null && this.withRtp()) {
            float computedWeightForLengthStep = Weights.computeWithRtp((Rtp)this.getRtp(), (float)row.getLengthStep().floatValue(), (String)this.getLengthStepCaracteristicUnit());
            computedWeight = Float.valueOf(Weights.convert((WeightUnit)WeightUnit.G, (WeightUnit)this.weightUnit, (float)((float)row.getNumber().intValue() * computedWeightForLengthStep)));
        }
        row.setRtpComputedWeight(computedWeight);
        if (this.isCopyRtpWeights() && !this.isCopyIndividualObservationAll()) {
            row.setWeight(computedWeight);
        }
    }

    public boolean withRtp() {
        return this.rtp != null;
    }

    public void recomputeRowsValidateState() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Revalidate all frequency rows");
        }
        this.rowsInError.clear();
        this.rows.forEach(row -> {
            boolean valid = this.isRowValid((SpeciesFrequencyRowModel)row);
            row.setValid(valid);
            if (!valid) {
                this.rowsInError.add(row);
            }
        });
        this.firePropertyChange("rowsInError", null, this.rowsInError);
    }

    protected final void recomputeRowValidState(SpeciesFrequencyRowModel row) {
        boolean valid = this.isRowValid(row);
        row.setValid(valid);
        if (valid) {
            this.removeRowInError(row);
        } else {
            this.addRowInError(row);
        }
    }

    public SpeciesOrBenthosBatchUISupport getSpeciesOrBenthosBatchUISupport() {
        return this.speciesOrBenthosBatchUISupport;
    }

    public WeightUnit getIndividualObservationWeightUnit() {
        return this.individualObservationWeightUnit;
    }

    public IndividualObservationBatchUIModel getIndividualObservationModel() {
        return this.individualObservationModel;
    }

    public boolean isNonEmptyIndividualObservationRowsInError() {
        return this.nonEmptyIndividualObservationRowsInError;
    }

    public void setNonEmptyIndividualObservationRowsInError(boolean nonEmptyIndividualObservationRowsInError) {
        boolean oldValue = this.isNonEmptyIndividualObservationRowsInError();
        this.nonEmptyIndividualObservationRowsInError = nonEmptyIndividualObservationRowsInError;
        this.firePropertyChanged(PROPERTY_NON_EMPTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR, oldValue, nonEmptyIndividualObservationRowsInError);
    }

    public void clear() {
        this.setRows(new ArrayList());
        this.recomputeCanEditLengthStep();
    }

    public IndividualObservationSamplingCacheRequest toSamplingCacheRequest(IndividualObservationBatchRowModel row) {
        return new IndividualObservationSamplingCacheRequest(this.fishingOperation, row.getSpecies(), this.getLengthStepInMm(row.getSize()), this.individualObservationModel.getMaturityValue(row), this.individualObservationModel.getGender(row), row.getSamplingCode());
    }

    public void addIndividualObservationsInCache(List<IndividualObservationBatchRowModel> individualObservations) {
        this.individualObservationUICache.addIndividualObservations(individualObservations);
        this.samplingCodeUICache.addIndividualObservations(individualObservations);
    }

    public List<IndividualObservationBatchRowModel> getValidIndividualObservations() {
        ArrayList<IndividualObservationBatchRowModel> result = new ArrayList<IndividualObservationBatchRowModel>(this.individualObservationModel.getRows());
        result.removeAll(this.individualObservationModel.getRowsInError());
        return result;
    }

    public void setFrequencyTableModel(SpeciesFrequencyTableModel frequencyTableModel) {
        this.frequencyTableModel = frequencyTableModel;
    }

    public SpeciesFrequencyTableModel getFrequencyTableModel() {
        return this.frequencyTableModel;
    }

    public boolean isProtocolFilled() {
        return this.protocolFilled;
    }

    public boolean isProtocolUseCalcifiedPieceSampling() {
        return this.protocolUseCalcifiedPieceSampling;
    }

    public void loadSpeciesBatch(SpeciesBatchRowModel speciesBatch) {
        Integer number = speciesBatch.getNumber();
        this.setSimpleCount(number);
        this.setTotalNumber(null);
        this.setTotalComputedWeight(null);
        this.setTotalWeight(null);
        this.setTotalWeight(speciesBatch.getWeight());
    }

    public FrequencyConfigurationMode guessFrequencyConfigurationMode() {
        FrequencyConfigurationMode mode = this.getSimpleCount() != null || this.lengthStepCaracteristic == null ? FrequencyConfigurationMode.SIMPLE_COUNTING : FrequencyConfigurationMode.FREQUENCIES;
        return mode;
    }
}

