/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.type.WeightUnit;
import org.nuiton.i18n.I18n;

public class SpeciesWeightComputingException
extends TuttiWeightComputingException {
    public static SpeciesWeightComputingException forValidationMessage(WeightUnit weightUnit, String message, String species, String categoryLabel, String categoryValue, Float weight, Float sampleCategoryWeight, int thisIndex) {
        String errorMessage = I18n.t((String)message, (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(weight.floatValue()), weightUnit.renderFromEntityWithShortLabel(sampleCategoryWeight.floatValue())});
        return new SpeciesWeightComputingException(errorMessage, "weight", thisIndex);
    }

    public static SpeciesWeightComputingException forIncoherentTotalSorted(WeightUnit weightUnit, Float speciesTotalSortedWeight, Float speciesTotalComputedSortedWeight) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentTotalSorted", (Object[])new Object[]{weightUnit.renderFromEntityWithShortLabel(speciesTotalSortedWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(speciesTotalComputedSortedWeight.floatValue())});
        return new SpeciesWeightComputingException(errorMessage);
    }

    public static SpeciesWeightComputingException forIncoherentParentCategoryWeight(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float categoryWeight, Float sum, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(categoryWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(sum.floatValue())});
        return new SpeciesWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    public static SpeciesWeightComputingException forIncoherentRowWeightFrequency(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float frequencyWeight, Float rowWeight, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(frequencyWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(rowWeight.floatValue())});
        return new SpeciesWeightComputingException(errorMessage, "weight", thisIndex);
    }

    public static SpeciesWeightComputingException forIncoherentCategoryWeight(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float frequencyWeight, Float categoryWeight, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(frequencyWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(categoryWeight.floatValue())});
        return new SpeciesWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    public static SpeciesWeightComputingException forNoWeight(String species, String categoryLabel, String categoryValue, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.species.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue});
        return new SpeciesWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    private SpeciesWeightComputingException(String message) {
        super(message);
    }

    private SpeciesWeightComputingException(String message, String property, int index) {
        super(message, property, index);
    }
}

