/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.SoundEngine;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class ApplySpeciesFrequencyRafaleAction {
    private static final Log log = LogFactory.getLog(ApplySpeciesFrequencyRafaleAction.class);
    protected final SpeciesFrequencyUI ui;
    protected final SoundEngine soundEngine;

    public ApplySpeciesFrequencyRafaleAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
        this.soundEngine = ui.getHandler().getContext().getSoundEngine();
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.ui.getModel();
        SpeciesFrequencyUIHandler handler = this.ui.getHandler();
        float aroundLengthStep = model.getLengthStep(step.floatValue());
        if (model.isCopyIndividualObservationNothing()) {
            SpeciesFrequencyTableModel tableModel = handler.getTableModel();
            SpeciesFrequencyRowModel row = tableModel.addRafaleRow(aroundLengthStep);
            int rowIndex = tableModel.getRowIndex((Serializable)((Object)row));
            model.recomputeTotalNumber();
            SwingUtilities.invokeLater(() -> this.selectRow(this.ui.getTable(), rowIndex));
        }
        JXTable logsTable = this.ui.getLogsTable();
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)logsTable.getModel());
        SpeciesFrequencyLogRowModel newLogRow = logsTableModel.createNewRow();
        newLogRow.setDate(new Date());
        newLogRow.setLengthStep(step);
        logsTableModel.addNewRow(0, (Serializable)((Object)newLogRow));
        if (model.isAddIndividualObservationOnRafale()) {
            IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)this.ui.getObsTable().getModel());
            int oldHeight = this.ui.getObsTable().getHeight();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("DEBUG before **** rowCount: %s oldHeight: %s", obsTableModel.getRowCount(), oldHeight));
            }
            IndividualObservationBatchRowModel obsRow = obsTableModel.addRafaleRow(step);
            newLogRow.setObsRow(obsRow);
            int rowIndex = obsTableModel.getRowIndex(obsRow);
            SwingUtilities.invokeLater(() -> {
                int newHeight = this.ui.getObsTable().getHeight();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("DEBUG invokeLater **** rowCount: %s newHeight: %s", obsTableModel.getRowCount(), newHeight));
                }
                if (oldHeight != newHeight) {
                    model.getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(true);
                    try {
                        this.selectRow(this.ui.getObsTable(), rowIndex);
                    }
                    finally {
                        model.getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(false);
                    }
                } else {
                    log.error((Object)"Scroll to added line is not possible, try to use fallback method");
                    this.selectRowWhenTableResized(this.ui.getObsTable(), rowIndex);
                }
            });
        }
        if (fromIchtyometer) {
            String unit = model.getLengthStepCaracteristicUnit();
            handler.showInformationMessage(I18n.t((String)"tutti.editSpeciesFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep), unit}));
            this.soundEngine.beepOnExternalDeviceDataReception(unit, aroundLengthStep);
        }
    }

    protected void selectRow(JXTable table, int rowIndex) {
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.scrollRowToVisible(rowIndex);
    }

    protected void selectRowWhenTableResized(final JXTable table, final int rowIndex) {
        table.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                log.error((Object)String.format("DEBUG ### remove listener: ", this.getClass().getName()));
                table.removeComponentListener((ComponentListener)this);
                ApplySpeciesFrequencyRafaleAction.this.ui.getModel().getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(true);
                try {
                    table.setRowSelectionInterval(rowIndex, rowIndex);
                    table.scrollRowToVisible(rowIndex);
                    table.removeComponentListener((ComponentListener)this);
                    int newHeight = ApplySpeciesFrequencyRafaleAction.this.ui.getObsTable().getHeight();
                    log.error((Object)String.format("DEBUG in selectRowWhenTableResized resized **** rowCount: %s newHeight: %s", table.getRowCount(), newHeight));
                }
                finally {
                    ApplySpeciesFrequencyRafaleAction.this.ui.getModel().getIndividualObservationModel().getSamplingNotificationZoneModel().setValueAdjusting(false);
                }
            }
        });
    }
}

