/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.util;

import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.util.Numbers;
import java.util.Objects;

public class Weights {
    public static float computeWithRtp(Rtp rtp, float lengthStep, String lengthStepUnit) {
        lengthStep = Numbers.convertToCm(lengthStep, lengthStepUnit);
        return (float)(rtp.getA() * Math.pow(lengthStep, rtp.getB().floatValue()));
    }

    public static float convert(WeightUnit sourceWeightUnit, WeightUnit targetWeightUnit, float sourceWeight) {
        Objects.requireNonNull(sourceWeightUnit);
        Objects.requireNonNull(targetWeightUnit);
        float sourceWeightToEntity = sourceWeightUnit.toEntity(Float.valueOf(sourceWeight)).floatValue();
        float targetWeightFromEntity = targetWeightUnit.fromEntity(Float.valueOf(sourceWeightToEntity)).floatValue();
        return targetWeightUnit.round(Float.valueOf(targetWeightFromEntity)).floatValue();
    }

    public static Float convert(WeightUnit sourceWeightUnit, WeightUnit targetWeightUnit, Float sourceWeight) {
        Float targetWeight = sourceWeight;
        if (sourceWeight != null) {
            targetWeight = Float.valueOf(Weights.convert(sourceWeightUnit, targetWeightUnit, sourceWeight.floatValue()));
        }
        return targetWeight;
    }
}

