/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.widgets.number.NumberEditorHandler;

public class ComputableDataEditorHandler
extends NumberEditorHandler {
    protected Integer decimalNumber;
    boolean displayNullComputedValue = true;

    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        };
        ComputableData computableData = (ComputableData)((Object)this.ui.getModel().getBean());
        if (computableData != null) {
            computableData.addPropertyChangeListener(l);
        }
        this.ui.getModel().addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableData newComputableData;
                ComputableData oldComputableData = (ComputableData)((Object)evt.getOldValue());
                if (oldComputableData != null) {
                    oldComputableData.removePropertyChangeListener("computedData", l);
                }
                if ((newComputableData = (ComputableData)((Object)evt.getNewValue())) != null) {
                    newComputableData.removePropertyChangeListener("computedData", l);
                    newComputableData.addPropertyChangeListener("computedData", l);
                }
            }
        });
        this.ui.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField tf = ComputableDataEditorHandler.this.ui.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (ComputableDataEditorHandler.this.ui.getModel().getNumberValue() == null) {
                    tf.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        });
        this.ui.addPropertyChangeListener("decimalNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.decimalNumber = (Integer)evt.getNewValue();
            }
        });
        this.decimalNumber = ((ComputableDataEditor)this.ui).getDecimalNumber();
        super.init();
    }

    public void reset() {
        this.displayNullComputedValue = false;
        try {
            this.setTextValue("");
        }
        finally {
            this.displayNullComputedValue = true;
        }
    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData)((Object)this.ui.getModel().getBean());
        JTextField tf = this.ui.getTextField();
        if (bean != null && bean.getData() == null && this.displayNullComputedValue && !tf.isFocusOwner()) {
            String modelText;
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor)this.ui).getComputedDataColor());
            Object computedData = bean.getComputedData();
            if (this.decimalNumber != null && computedData != null) {
                DecimalFormat decimalFormat = Weights.getDecimalFormat((int)1, (int)this.decimalNumber);
                modelText = decimalFormat.format(computedData);
            } else {
                modelText = JAXXUtil.getStringValue(computedData);
            }
            tf.setText(modelText);
        } else {
            tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }
}

