/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import org.eclipse.birt.data.engine.api.timefunction.IParallelPeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;

public class PreviousNPeriodsFunction
extends AbstractMDX
implements IParallelPeriod {
    private String levelName;
    private int offset;

    public PreviousNPeriodsFunction(String levelName, int offset) {
        this.levelName = levelName;
        this.offset = offset;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public TimeMember getResult(TimeMember member) {
        String[] levels = member.getLevelType();
        int[] values = member.getMemberValue();
        GregorianCalendar cal = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
        cal.clear();
        this.translateToCal((Calendar)cal, levels, values);
        if (this.levelName.equals("year")) {
            cal.add(1, this.offset);
        } else if (this.levelName.equals("quarter")) {
            cal.add(2, this.offset * 3);
        } else if (this.levelName.equals("month")) {
            cal.add(2, this.offset);
        } else if (this.levelName.equals("week-of-month")) {
            cal.add(4, this.offset);
        } else if (this.levelName.equals("week-of-year")) {
            cal.add(3, this.offset);
        } else if (this.levelName.equals("day-of-month")) {
            cal.add(5, this.offset);
        } else if (this.levelName.equals("day-of-year")) {
            cal.add(6, this.offset);
        } else if (this.levelName.equals("day-of-week")) {
            cal.add(7, this.offset);
        }
        int[] newValues = this.getValueFromCal((Calendar)cal, levels);
        TimeMember newMember = new TimeMember(newValues, levels);
        return newMember;
    }
}

