/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin.signs;

import com.google.common.base.Function;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.signs.Sign;
import java.util.Map;

public enum Size implements Sign
{
    NOT_SIZED("0"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.UNSORTED.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return true;
        }
    }
    ,
    SMALL("1"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SIZE_SMALL.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return false;
        }
    }
    ,
    BIG("2"){

        @Override
        public Integer getCategory() {
            return PmfmId.SIZE_CATEGORY.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SIZE_BIG.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return false;
        }
    };

    private String sign;

    private Size(String sign) {
        this.sign = sign;
    }

    @Override
    public String getSign() {
        return this.sign;
    }

    @Override
    public void registerSign(Caracteristic caracteristic, Map<Sign, CaracteristicQualitativeValue> map) {
        Integer valueId = this.getQualitativeValueId();
        CaracteristicQualitativeValue result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)valueId);
        map.put(this, result);
    }

    public static Size getValue(String sign) {
        Size result = null;
        for (Size s : Size.values()) {
            if (!s.sign.equals(sign)) continue;
            result = s;
            break;
        }
        return result;
    }

    public static Function<BigfinDataRow, Sign> newExtractValueFunction() {
        return new Function<BigfinDataRow, Sign>(){

            public Sign apply(BigfinDataRow bigfinDataRow) {
                Size result = bigfinDataRow.getSize();
                return result;
            }
        };
    }
}

