/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.BoxType;
import fr.ifremer.tutti.service.pupitri.PupitriSignContext;
import fr.ifremer.tutti.service.pupitri.Signs;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PupitriSpeciesContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MELAG_META_SPECIES = "MELA-NGE";
    private static final String MELAG_2_META_SPECIES = "MELANGE";
    private static final Set<String> MELAG_SPECIES = ImmutableSet.of((Object)"MELA-NGE", (Object)"MELANGE");
    private static final Set<Signs> DEFAULT_SIGNS = ImmutableSet.of((Object)((Object)Signs.DEFAULT));
    private static final Set<Signs> UNSORTED_SIGNS = ImmutableSet.of((Object)((Object)Signs.UNSORTED));
    private static final Set<Signs> SEX_SIGNS = ImmutableSet.of((Object)((Object)Signs.DEFAULT), (Object)((Object)Signs.MALE), (Object)((Object)Signs.FEMALE));
    private static final Set<Signs> SIZE_SIGNS = ImmutableSet.of((Object)((Object)Signs.SMALL), (Object)((Object)Signs.MEDIUM), (Object)((Object)Signs.BIG));
    protected final Species species;
    protected final boolean sorted;
    protected Signs melagElevatedSign;
    protected final TreeMap<Signs, PupitriSignContext> signs;
    protected final boolean createMissingSigns;

    public PupitriSpeciesContext(Species species, boolean createMissingSigns, boolean sorted) {
        this.species = species;
        this.sorted = sorted;
        this.signs = new TreeMap();
        this.createMissingSigns = createMissingSigns;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isAddMelagComment(Signs sign) {
        return this.melagElevatedSign != null && this.melagElevatedSign.equals((Object)sign);
    }

    public boolean isForMelag() {
        return this.signs.containsKey((Object)Signs.MELAG);
    }

    public boolean isMelagMetaSpecies() {
        boolean melagMetaSpecies = MELAG_SPECIES.contains(this.species.getSurveyCode());
        return melagMetaSpecies;
    }

    public boolean containsSign(Signs signs) {
        return this.signs.containsKey((Object)signs);
    }

    public Set<Signs> getSigns() {
        return ImmutableSet.copyOf(this.signs.keySet());
    }

    public float getWeight(Signs signs) {
        PupitriSignContext signContext = this.getSignContext(signs);
        return signContext.getWeight();
    }

    public float getTotalWeight() {
        float totalWeight = 0.0f;
        for (PupitriSignContext signContext : this.signs.values()) {
            float weight = signContext.getWeight();
            totalWeight += weight;
        }
        return totalWeight;
    }

    public void addToSignContext(Signs sign, BoxType boxType, Float weight) {
        PupitriSignContext signContext = this.getOrCreateSignContext(sign);
        signContext.addWeight(weight.floatValue());
        switch (boxType) {
            case SMALL: {
                signContext.incrementNbSmallBox();
                break;
            }
            case BIG: {
                signContext.incrementNbBigBox();
            }
        }
        if (this.createMissingSigns) {
            switch (sign) {
                case MALE: {
                    this.getOrCreateSignContext(Signs.FEMALE);
                    this.getOrCreateSignContext(Signs.DEFAULT);
                    break;
                }
                case FEMALE: {
                    this.getOrCreateSignContext(Signs.MALE);
                    this.getOrCreateSignContext(Signs.DEFAULT);
                    break;
                }
                case SMALL: {
                    this.getOrCreateSignContext(Signs.BIG);
                    break;
                }
                case BIG: {
                    this.getOrCreateSignContext(Signs.SMALL);
                }
            }
        }
    }

    public void setMelagElevatedWeight(Signs melagElevatedSign, Float weight) {
        PupitriSignContext melagContext = this.getSignContext(Signs.MELAG);
        PupitriSignContext pupitriSignContext = this.getOrCreateSignContext(melagElevatedSign);
        pupitriSignContext.addWeight(weight.floatValue());
        pupitriSignContext.addNbBoxs(melagContext);
        this.signs.remove((Object)Signs.MELAG);
        this.melagElevatedSign = melagElevatedSign;
    }

    public void moveMelagToDefaultSign() {
        PupitriSignContext melagContext = this.getSignContext(Signs.MELAG);
        PupitriSignContext defaultSignContext = this.getOrCreateSignContext(Signs.DEFAULT);
        defaultSignContext.addWeight(melagContext.getWeight());
        defaultSignContext.addNbBoxs(melagContext);
        this.signs.remove((Object)Signs.MELAG);
    }

    public boolean isSplitSpecies() {
        boolean contains;
        HashSet<Signs> allSigns = new HashSet<Signs>(this.signs.keySet());
        boolean result = DEFAULT_SIGNS.equals(allSigns) ? false : (UNSORTED_SIGNS.equals(allSigns) ? false : ((contains = allSigns.removeAll(SEX_SIGNS)) ? allSigns.isEmpty() : ((contains = allSigns.removeAll(SIZE_SIGNS)) ? allSigns.isEmpty() : false)));
        return result;
    }

    public int hashCode() {
        int speciesHashCode = this.species != null ? this.species.hashCode() : 0;
        int sortedHashCode = this.sorted ? 0x55555555 : 0x2AAAAAAA;
        return speciesHashCode ^ sortedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PupitriSpeciesContext other = (PupitriSpeciesContext)obj;
        if (!(this.species == other.species || this.species != null && this.species.equals(other.species))) {
            return false;
        }
        return this.sorted == other.sorted;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("species", (Object)this.species.getSurveyCode()).append("sorted", this.sorted).append("signs", this.signs).toString();
    }

    PupitriSignContext getSignContext(Signs sign) {
        return this.signs.get((Object)sign);
    }

    private PupitriSignContext getOrCreateSignContext(Signs sign) {
        PupitriSignContext signContext = this.getSignContext(sign);
        if (signContext == null) {
            signContext = new PupitriSignContext(sign);
            this.signs.put(sign, signContext);
        }
        return signContext;
    }
}

