/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableInt;

public class ExportBatchEntry {
    protected final SpeciesAbleBatch batch;
    protected float sortedWeight;
    protected float totalWeight;
    protected int totalNumber;
    protected Map<Float, MutableInt> frequencies;

    public ExportBatchEntry(SpeciesAbleBatch batch) {
        this.batch = batch;
        this.frequencies = new TreeMap<Float, MutableInt>();
    }

    public SpeciesAbleBatch getBatch() {
        return this.batch;
    }

    public void addSortedWeight(float weight) {
        this.sortedWeight += weight;
    }

    public void addTotalWeight(float weight) {
        this.totalWeight += weight;
    }

    public void addNumber(int number) {
        this.totalNumber += number;
    }

    public void addFrequency(float lengthStep, int number) {
        MutableInt totalNumber = this.frequencies.get(Float.valueOf(lengthStep));
        if (totalNumber == null) {
            totalNumber = new MutableInt();
            this.frequencies.put(Float.valueOf(lengthStep), totalNumber);
        }
        totalNumber.add(number);
    }

    public float getSortedWeight() {
        return this.sortedWeight;
    }

    public float getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalNumber() {
        return this.totalNumber;
    }

    public Float getAverageFrequency() {
        int totNumber = 0;
        float totSize = 0.0f;
        for (Map.Entry<Float, MutableInt> entry : this.frequencies.entrySet()) {
            float size = entry.getKey().floatValue();
            int number = entry.getValue().intValue();
            totSize += size * (float)number;
            totNumber += number;
        }
        Float result = totNumber == 0 ? null : Float.valueOf(totSize / (float)totNumber);
        return result;
    }
}

