/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AsyncExecutionAspectSupport
implements BeanFactoryAware {
    private final Map<Method, AsyncTaskExecutor> executors = new ConcurrentHashMap<Method, AsyncTaskExecutor>(16);
    private Executor defaultExecutor;
    private BeanFactory beanFactory;

    public AsyncExecutionAspectSupport(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public void setExecutor(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected AsyncTaskExecutor determineAsyncExecutor(Method method) {
        AsyncTaskExecutor executor = this.executors.get(method);
        if (executor == null) {
            Executor executorToUse = this.defaultExecutor;
            String qualifier = this.getExecutorQualifier(method);
            if (StringUtils.hasLength((String)qualifier)) {
                Assert.notNull((Object)this.beanFactory, (String)("BeanFactory must be set on " + this.getClass().getSimpleName() + " to access qualified executor '" + qualifier + "'"));
                executorToUse = (Executor)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.beanFactory, Executor.class, (String)qualifier);
            } else if (executorToUse == null) {
                return null;
            }
            executor = executorToUse instanceof AsyncTaskExecutor ? (AsyncTaskExecutor)executorToUse : new TaskExecutorAdapter(executorToUse);
            this.executors.put(method, executor);
        }
        return executor;
    }

    protected abstract String getExecutorQualifier(Method var1);
}

