/*
 * #%L
 * SIH-Adagio
 * $Id: javaMergeMappings.xml 12002 2014-03-26 10:17:22Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.5/mda/src/main/config/javaMergeMappings.xml $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
//
// Attention: Generated code! Do not modify by hand!
// Generated by: TypeSafeEnumeration.vsl in andromda-java-cartridge.
// Model Class:  Data::fr.ifremer.adagio.core.dao::referential::taxon::TaxonomicLevelCode
// Metafacade:   org.andromda.metafacades.uml.Enumeration
// Stereotype:  Enumeration
//
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import static org.nuiton.i18n.I18n.n;

/**
 * 
 */
public enum TaxonomicLevelCode
    implements Serializable, AdagioEnumerationDef<String>
{
    /** TODO: Model Documentation for Enumeration Literal SPECIES value "5" */
    SPECIES (
			"adagio.enumeration.TaxonomicLevelCode.SPECIES", 
			n("adagio.enumeration.TaxonomicLevelCode.SPECIES.description"), 
			"5"),
    /** TODO: Model Documentation for Enumeration Literal VARIETY value "6" */
    VARIETY (
			"adagio.enumeration.TaxonomicLevelCode.VARIETY", 
			n("adagio.enumeration.TaxonomicLevelCode.VARIETY.description"), 
			"6");

    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 8223541003588511153L;

    private String key;
    private String description;
    private String enumValue;

    private TaxonomicLevelCode(String key, String description, String value)
    {
    	this.key = key;
    	this.description = description;
        this.enumValue = value;
    }
    
    @Override
    public void setValue(String newValue) {
		if (newValue != null && !this.enumValue.equals(newValue)) {
			// Update static lists
	    	values.remove(this.enumValue);
	    	literals.remove(this.enumValue);
	    	this.enumValue = newValue;
	    	values.put(this.enumValue, this);
	    	literals.add(this.enumValue);
		}
    }
    

    @Override
    public String getValueAsString()
    {
        return String.valueOf(this.enumValue);
    }

    /**
     * Retrieves an instance of TaxonomicLevelCode from <code>its name</code>.
     *
     * @param name the name to create the TaxonomicLevelCode from.
     * @return The enumeration literal named after the 'name' argument
     */
    public static TaxonomicLevelCode fromString(String name)
    {
        return TaxonomicLevelCode.valueOf(name);
    }

    /**
     * Returns an enumeration literal String <code>value</code>.
     * Required by JAXB2 enumeration implementation
     *
     * @return String with corresponding value
     */
    public String value()
    {
        return this.enumValue;
    }

    /**
     * Returns an instance of TaxonomicLevelCode from String <code>value</code>.
     * Required by JAXB2 enumeration implementation
     *
     * @param value the value to create the TaxonomicLevelCode from.
     * @return static Enumeration with corresponding value
     */
    public static TaxonomicLevelCode fromValue(String value)
    {
        for (TaxonomicLevelCode enumName: TaxonomicLevelCode.values())
        {
            if (enumName.getValue().equals(value))
            {
                return enumName;
            }
        }
        throw new IllegalArgumentException("TaxonomicLevelCode.fromValue(" + value + ')');
    }

    /**
     * Gets the underlying value of this type safe enumeration.
     * This method is necessary to comply with DaoBase implementation.
     * @return The name of this literal.
     */
    public String getValue()
    {
        return this.enumValue;
    }
    
    @Override
    public String getDescription() {
    	return description;
    }
    
    @Override
    public String getKey() {
    	return key;
    }
    
    @Override
    public Class<?> getType() {
    	return String.class;
    }
    
    /**
     * Returns an unmodifiable list containing the literals that are known by this enumeration.
     *
     * @return A List containing the actual literals defined by this enumeration, this list
     *         can not be modified.
     */
    public static List<String> literals()
    {
        return TaxonomicLevelCode.literals;
    }

    /**
     * Returns an unmodifiable list containing the names of the literals that are known
     * by this enumeration.
     *
     * @return A List containing the actual names of the literals defined by this
     *         enumeration, this list can not be modified.
     */
    public static List<String> names()
    {
        return TaxonomicLevelCode.names;
    }

    private static Map<String, TaxonomicLevelCode> values = new LinkedHashMap<String, TaxonomicLevelCode>(2, 1);
    private static List<String> literals = new ArrayList<String>(2);
    private static List<String> names = new ArrayList<String>(2);
    private static List<TaxonomicLevelCode> valueList = new ArrayList<TaxonomicLevelCode>(2);

    /**
     * Initializes the values.
     */
    static
    {
        synchronized (TaxonomicLevelCode.values)
        {
            TaxonomicLevelCode.values.put(SPECIES.enumValue, SPECIES);
            TaxonomicLevelCode.values.put(VARIETY.enumValue, VARIETY);
        }
        synchronized (TaxonomicLevelCode.valueList)
        {
            TaxonomicLevelCode.valueList.add(SPECIES);
            TaxonomicLevelCode.valueList.add(VARIETY);
            // For Adagio, lists could be reload from configuration
            //TaxonomicLevelCode.valueList = Collections.unmodifiableList(valueList);
        }
        synchronized (TaxonomicLevelCode.literals)
        {
            TaxonomicLevelCode.literals.add(SPECIES.enumValue);
            TaxonomicLevelCode.literals.add(VARIETY.enumValue);
            // For Adagio, lists could be reload from configuration
            //TaxonomicLevelCode.literals = Collections.unmodifiableList(literals);
        }
        synchronized (TaxonomicLevelCode.names)
        {
            TaxonomicLevelCode.names.add("SPECIES");
            TaxonomicLevelCode.names.add("VARIETY");
            TaxonomicLevelCode.names = Collections.unmodifiableList(names);
        }
    }
    // type-safe-enumeration-object java merge-point
}