/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.protocol;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId2;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.AbstractTuttiProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.v1.SpeciesProtocol1;
import fr.ifremer.tutti.persistence.entities.protocol.v1.SpeciesProtocolBean1;
import fr.ifremer.tutti.persistence.entities.protocol.v1.TuttiProtocol1;
import fr.ifremer.tutti.persistence.entities.protocol.v1.TuttiProtocolBean1;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class TuttiProtocols
extends AbstractTuttiProtocols {
    private static final Log log = LogFactory.getLog(TuttiProtocols.class);

    public static void toFile(TuttiProtocol protocol, File file) {
        String id = protocol.getId();
        BufferedWriter fileWriter = null;
        try {
            fileWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            YamlWriter writer = new YamlWriter((Writer)fileWriter, TuttiProtocols.createConfig());
            writer.write((Object)protocol);
            writer.close();
            fileWriter.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.persistence.protocol.fromFile.error", (Object[])new Object[]{id, file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuttiProtocol fromFile(File file) {
        BufferedReader fileReader = null;
        try {
            ArrayList mandatorySampleCategoryIdInteger;
            List<Integer> mandatorySampleCategoryId;
            fileReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            YamlReader reader = new YamlReader((Reader)fileReader, TuttiProtocols.createConfig());
            TuttiProtocol result = (TuttiProtocol)reader.read(TuttiProtocols.typeOfTuttiProtocol());
            ((Reader)fileReader).close();
            Integer sampleCategoryIdToRemove = PmfmId2.SORTED_UNSORTED.getValue();
            if (!result.isBenthosEmpty()) {
                for (SpeciesProtocol speciesProtocol : result.getBenthos()) {
                    mandatorySampleCategoryId = speciesProtocol.getMandatorySampleCategoryId();
                    mandatorySampleCategoryIdInteger = Lists.newArrayList();
                    for (Integer o : mandatorySampleCategoryId) {
                        mandatorySampleCategoryIdInteger.add(Integer.valueOf(((Object)o).toString()));
                    }
                    mandatorySampleCategoryIdInteger.remove(sampleCategoryIdToRemove);
                    speciesProtocol.setMandatorySampleCategoryId(mandatorySampleCategoryIdInteger);
                }
            }
            if (!result.isSpeciesEmpty()) {
                for (SpeciesProtocol speciesProtocol : result.getSpecies()) {
                    mandatorySampleCategoryId = speciesProtocol.getMandatorySampleCategoryId();
                    mandatorySampleCategoryIdInteger = Lists.newArrayList();
                    for (Integer o : mandatorySampleCategoryId) {
                        mandatorySampleCategoryIdInteger.add(Integer.valueOf(((Object)o).toString()));
                    }
                    mandatorySampleCategoryIdInteger.remove(sampleCategoryIdToRemove);
                    speciesProtocol.setMandatorySampleCategoryId(mandatorySampleCategoryIdInteger);
                }
            }
            TuttiProtocol tuttiProtocol = result;
            return tuttiProtocol;
        }
        catch (Exception e) {
            TuttiProtocol result;
            TuttiProtocol1 tuttiProtocol1 = TuttiProtocols.fromFileV1(file);
            TuttiProtocol tuttiProtocol = result = TuttiProtocols.fromTuttiProtocol1(tuttiProtocol1);
            return tuttiProtocol;
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
    }

    public static TuttiProtocol1 fromFileV1(File file) {
        BufferedReader fileReader = null;
        try {
            fileReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            YamlReader reader = new YamlReader((Reader)fileReader, TuttiProtocols.createConfigV1());
            TuttiProtocol1 result = (TuttiProtocol1)reader.read(TuttiProtocolBean1.class);
            ((Reader)fileReader).close();
            TuttiProtocol1 tuttiProtocol1 = result;
            return tuttiProtocol1;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.persistence.protocol.fromFile.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
    }

    public static void checkSampleCategories(SampleCategoryModel sampleCategoryModel, TuttiProtocol protocol, Set<Integer> badCategories) {
        List<Integer> mandatorySampleCategoryId;
        if (CollectionUtils.isNotEmpty(protocol.getSpecies())) {
            for (SpeciesProtocol entry : protocol.getSpecies()) {
                mandatorySampleCategoryId = entry.getMandatorySampleCategoryId();
                for (Integer categoryId : mandatorySampleCategoryId) {
                    if (sampleCategoryModel.containsCategoryId(categoryId)) continue;
                    badCategories.add(categoryId);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(protocol.getBenthos())) {
            for (SpeciesProtocol entry : protocol.getBenthos()) {
                mandatorySampleCategoryId = entry.getMandatorySampleCategoryId();
                for (Integer categoryId : mandatorySampleCategoryId) {
                    if (sampleCategoryModel.containsCategoryId(categoryId)) continue;
                    badCategories.add(categoryId);
                }
            }
        }
    }

    public static void removeBadCategories(SampleCategoryModel sampleCategoryModel, TuttiProtocol protocol) {
        List<Integer> samplingOrder = sampleCategoryModel.getSamplingOrder();
        if (!protocol.isSpeciesEmpty()) {
            for (SpeciesProtocol entry : protocol.getSpecies()) {
                entry.getMandatorySampleCategoryId().retainAll(samplingOrder);
            }
        }
        if (!protocol.isBenthosEmpty()) {
            for (SpeciesProtocol entry : protocol.getBenthos()) {
                entry.getMandatorySampleCategoryId().retainAll(samplingOrder);
            }
        }
    }

    public static void removeBadSpecies(Set<Integer> speciesIds, List<SpeciesProtocol> protocol) {
        Iterator<SpeciesProtocol> iterator = protocol.iterator();
        while (iterator.hasNext()) {
            SpeciesProtocol next = iterator.next();
            if (!speciesIds.contains(next.getSpeciesReferenceTaxonId())) continue;
            iterator.remove();
        }
    }

    public static String getBadCategoriesMessage(Set<Integer> badCategories, Decorator<Caracteristic> decorator, TuttiPersistence persistenceService) {
        ArrayList badCategoriesStr = Lists.newArrayList();
        for (Integer id : badCategories) {
            String caracteristicStr;
            try {
                Caracteristic caracteristic = persistenceService.getCaracteristic(id);
                caracteristicStr = decorator.toString((Object)caracteristic);
            }
            catch (NullPointerException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not find caracteristic with id: " + id));
                }
                caracteristicStr = I18n.t((String)"tutti.persistence.error.caracteristic.notFound", (Object[])new Object[0]);
            }
            badCategoriesStr.add("<li>" + id + " : " + caracteristicStr + "</li>");
        }
        String message = I18n.t((String)"tutti.persistence.error.protocol.categories.not.compatible", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)badCategoriesStr)});
        return message;
    }

    public static String getBadSpeciesMessage(Map<Integer, String> badSpecies) {
        ArrayList badCategoriesStr = Lists.newArrayList();
        for (Map.Entry<Integer, String> id : badSpecies.entrySet()) {
            badCategoriesStr.add("<li>" + id.getKey() + " : " + (id.getValue() == null ? "" : id.getValue()) + "</li>");
        }
        String message = I18n.t((String)"tutti.persistence.error.protocol.species.not.found", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)badCategoriesStr)});
        return message;
    }

    public static String getBadBenthosMessage(Map<Integer, String> badSpecies) {
        ArrayList badCategoriesStr = Lists.newArrayList();
        for (Map.Entry<Integer, String> id : badSpecies.entrySet()) {
            badCategoriesStr.add("<li>" + id.getKey() + " : " + (id.getValue() == null ? "" : id.getValue()) + "</li>");
        }
        String message = I18n.t((String)"tutti.persistence.error.protocol.benthos.not.found", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)badCategoriesStr)});
        return message;
    }

    protected static TuttiProtocol fromTuttiProtocol1(TuttiProtocol1 tuttiProtocol1) {
        SpeciesProtocol row;
        Binder binderSpecies;
        TuttiProtocol result = TuttiProtocols.newTuttiProtocol();
        Binder binder = BinderFactory.newBinder(TuttiProtocol1.class, TuttiProtocol.class);
        binder.copy((Object)tuttiProtocol1, (Object)result, new String[0]);
        if (!tuttiProtocol1.isSpeciesEmpty()) {
            result.setSpecies(Lists.newArrayList());
            binderSpecies = BinderFactory.newBinder(SpeciesProtocol1.class, SpeciesProtocol.class);
            for (SpeciesProtocol1 speciesProtocol1 : tuttiProtocol1.getSpecies()) {
                row = SpeciesProtocols.newSpeciesProtocol();
                row.setMandatorySampleCategoryId(Lists.newArrayList());
                binderSpecies.copy((Object)speciesProtocol1, (Object)row, new String[0]);
                if (speciesProtocol1.isAgeEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.AGE.getValue());
                }
                if (speciesProtocol1.isSizeEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.SIZE_CATEGORY.getValue());
                }
                if (speciesProtocol1.isMaturityEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.MATURITY.getValue());
                }
                if (speciesProtocol1.isSexEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.SEX.getValue());
                }
                result.addSpecies(row);
            }
        }
        if (!tuttiProtocol1.isBenthosEmpty()) {
            result.setBenthos(Lists.newArrayList());
            binderSpecies = BinderFactory.newBinder(SpeciesProtocol1.class, SpeciesProtocol.class);
            for (SpeciesProtocol1 speciesProtocol1 : tuttiProtocol1.getBenthos()) {
                row = SpeciesProtocols.newSpeciesProtocol();
                row.setMandatorySampleCategoryId(Lists.newArrayList());
                binderSpecies.copy((Object)speciesProtocol1, (Object)row, new String[0]);
                if (speciesProtocol1.isAgeEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.AGE.getValue());
                }
                if (speciesProtocol1.isSizeEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.SIZE_CATEGORY.getValue());
                }
                if (speciesProtocol1.isMaturityEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.MATURITY.getValue());
                }
                if (speciesProtocol1.isSexEnabled()) {
                    row.addMandatorySampleCategoryId(PmfmId2.SEX.getValue());
                }
                result.addBenthos(row);
            }
        }
        return result;
    }

    protected static YamlConfig createConfig() {
        YamlConfig result = new YamlConfig();
        result.setClassTag(SpeciesProtocol.class.getSimpleName(), SpeciesProtocols.typeOfSpeciesProtocol());
        result.writeConfig.setAlwaysWriteClassname(false);
        result.writeConfig.setWriteRootTags(false);
        return result;
    }

    protected static YamlConfig createConfigV1() {
        YamlConfig result = new YamlConfig();
        result.setClassTag(SpeciesProtocol.class.getSimpleName(), SpeciesProtocolBean1.class);
        result.writeConfig.setAlwaysWriteClassname(false);
        result.writeConfig.setWriteRootTags(false);
        return result;
    }

    public static SpeciesProtocol getSpeciesProtocol(TuttiProtocol protocol, Species species) {
        return TuttiProtocols.getSpeciesProtocol(species, protocol.getSpecies());
    }

    public static SpeciesProtocol getSpeciesProtocol(Species species, List<SpeciesProtocol> speciesProtocols) {
        for (SpeciesProtocol speciesProtocol : speciesProtocols) {
            if (!species.getReferenceTaxonId().equals(speciesProtocol.getSpeciesReferenceTaxonId())) continue;
            return speciesProtocol;
        }
        return null;
    }
}

